/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.admin.util;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

public class AdminInfoScrollPane
extends Canvas
implements Runnable,
MouseListener {
    private Thread m_thread;
    private Image m_textImage;
    private Font m_textfont;
    private Font m_headfont;
    private Color m_defaultcolor;
    private Color m_bkColor;
    private Dimension m_appSize;
    private Vector m_msgList;
    private Vector m_tagList;
    private Vector m_colorList;
    private int m_msgIndex = 0;
    private int m_yDistance = 0;
    private int m_imageWidth = 0;
    private int m_imageHeight = 0;
    private boolean m_run;
    private boolean m_run_status;
    static String m_wait_msg = new String("Please wait...");
    public static final String HEAD = "HEAD";
    public static final String TEXT = "TEXT";

    public AdminInfoScrollPane(Vector vector, Vector vector2, Vector vector3, Font font, Font font2, Color color, Color color2) {
        this.m_msgList = vector;
        this.m_tagList = vector2;
        this.m_colorList = vector3;
        this.m_textfont = font;
        this.m_headfont = font2;
        this.m_defaultcolor = color;
        this.m_bkColor = color2;
        this.m_textImage = null;
        this.m_run = true;
        this.m_run_status = false;
        this.addMouseListener(this);
        this.setBackground(this.m_bkColor);
    }

    public void start() {
        if (!this.m_run_status) {
            this.m_run_status = true;
            this.m_appSize = this.getSize();
            this.m_yDistance = this.m_appSize.height;
            this.m_textImage = this.createTextImage();
            this.m_thread = new Thread(this);
            this.m_thread.start();
        }
    }

    public synchronized void resume() {
        this.m_run = true;
    }

    public synchronized void stop() {
        this.m_run_status = false;
        this.m_run = false;
    }

    public void destroy() {
        this.m_thread = null;
    }

    private Image createTextImage() {
        Image image = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            FontMetrics fontMetrics = toolkit.getFontMetrics(this.m_textfont);
            FontMetrics fontMetrics2 = toolkit.getFontMetrics(this.m_headfont);
            n = fontMetrics.getHeight();
            n2 = fontMetrics2.getHeight();
            this.m_imageWidth = this.m_appSize.width;
            this.m_imageHeight = 0;
            int n4 = 0;
            while (n4 < this.m_msgList.size()) {
                this.m_imageHeight += this.m_tagList.elementAt(n4).equals(HEAD) ? n2 : n;
                ++n4;
            }
            this.m_imageHeight += n2;
            image = this.createImage(this.m_imageWidth, this.m_imageHeight);
            Graphics graphics = image.getGraphics();
            graphics.setColor(this.m_bkColor);
            graphics.fillRect(0, 0, this.m_imageWidth, this.m_imageHeight);
            int n5 = 0;
            while (n5 < this.m_msgList.size()) {
                boolean bl = this.m_tagList.elementAt(n5).equals(HEAD);
                graphics.setFont(bl ? this.m_headfont : this.m_textfont);
                graphics.setColor((Color)this.m_colorList.elementAt(n5));
                String string = (String)this.m_msgList.elementAt(n5);
                FontMetrics fontMetrics3 = bl ? fontMetrics2 : fontMetrics;
                int n6 = (this.m_imageWidth - fontMetrics3.stringWidth(string)) / 2;
                int n7 = bl ? n2 : n;
                graphics.drawString(string, n6, n3 += n7);
                ++n5;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return image;
    }

    public void update(Graphics graphics) {
        if (this.m_textImage == null) {
            graphics.setFont(this.m_textfont);
            graphics.setColor(Color.green);
            graphics.drawString(m_wait_msg, 10, 20);
            return;
        }
        graphics.drawImage(this.m_textImage, 0, this.m_yDistance, this);
    }

    public void run() {
        try {
            while (true) {
                Thread.sleep(60L);
                if (!this.m_run) continue;
                --this.m_yDistance;
                if (this.m_yDistance < -this.m_imageHeight) {
                    this.m_yDistance = this.m_appSize.height;
                }
                this.repaint();
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof AdminInfoScrollPane) {
            this.stop();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof AdminInfoScrollPane) {
            this.resume();
        }
    }
}

