/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.wallet;

import java.util.Enumeration;
import java.util.Vector;
import oracle.security.admin.util.AdminTRACE;
import oracle.security.wallet.NZCertificate;
import oracle.security.wallet.NZException;
import oracle.security.wallet.NZNative;
import oracle.security.wallet.NZPersona;
import oracle.security.wallet.WalletCache;

public class NZWallet {
    private String myWrl;
    private String myPassword;
    private int myRioType = 21;
    private String myLdapDN;
    private int mySecurePolicy = 0;
    private int myOpenPolicy = 0;
    private Vector myPersonaVec = new Vector();
    private byte[] myWltPtr;
    public static String rsaSecureStvAuth = "-----BEGIN CERTIFICATE-----\nMIICNDCCAaECEAKtZn5ORf5eV288mBle3cAwDQYJKoZIhvcNAQECBQAwXzELMAkGA1UEBhMCVVMxIDAeBgNVBAoTF1JTQSBEYXRhIFNlY3VyaXR5LCBJbmMuMS4wLAYDVQQLEyVTZWN1cmUgU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTk0MTEwOTAwMDAwMFoXDTEwMDEwNzIzNTk1OVowXzELMAkGA1UEBhMCVVMxIDAeBgNVBAoTF1JTQSBEYXRhIFNlY3VyaXR5LCBJbmMuMS4wLAYDVQQLEyVTZWN1cmUgU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGbMA0GCSqGSIb3DQEBAQUAA4GJADCBhQJ+AJLOesGugz5aqomDV6wlAXYMra6OLDfO6zV4ZFQD5YRAUcm/jwjiioII0haGN1XpsSECrXZogZoFokvJSyVmIlZsiAeP94FZbYQHZXATcXY+m3dM41CJVphIuR2nKRoTLkoRWZweFdVJVCxzOmmCsZc5nG1wZ0jl3S3WyB57AgMBAAEwDQYJKoZIhvcNAQECBQADfgBl3X7hsuyw4jrg7HFGmhkRuNPHoLQDQCYCPgmc4RKz0Vr2N6W3YQO2WxZpO8ZECAyIUwxrl0nHPjXcbLm7qt9cuzovk2C2qUtN8iD3zV9/ZHuO3ABc1/p3yjkWWW8O6tO1g39NTUJWdrTJXwT4OPjr0l91X817/OWOgHz8UA==\n-----END CERTIFICATE-----\n";
    public static final String Verisign_class1 = "-----BEGIN CERTIFICATE-----\nMIICPDCCAaUCEDJQM89Q0VbzXIGtZVxPyCUwDQYJKoZIhvcNAQECBQAwXzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAxIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTk2MDEyOTAwMDAwMFoXDTIwMDEwNzIzNTk1OVowXzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAxIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDlGb9to1ZhLZlIcfZn3rmN67eehoAKkQ76OCWvRoiC5XOooJskXQ0fzGVuDLDQVoQYh5oGmxChc9+0WDlrbsH2FdWoqD+qEgaNMax/sDTXjzRniAnNFBHiTkVWaR94AoDa3EeRKbs2yWNcxeDXLYd7obcysHswuiovMaruo2fa2wIDAQABMA0GCSqGSIb3DQEBAgUAA4GBAEtEZmBoZOSYG/OwcuaViXzde7OVwB0u2NgZ0C00PcZQmhCGjKo/O6gE/DdSlcPZydvN8oYGxLEb8IKIMEKOF1AcZHq4PplJdJf8rAJD+5YMVgQlDHx8h50kp9jwMim1pN9dokzFFjKoQvZFprY2ueC/ZTaTwtLXa9zeWdaiNfhF\n-----END CERTIFICATE-----\n";
    public static final String Verisign_class2 = "-----BEGIN CERTIFICATE-----\nMIICPTCCAaYCEQC6WslMBTuS1qe2307QU5INMA0GCSqGSIb3DQEBAgUAMF8xCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjE3MDUGA1UECxMuQ2xhc3MgMiBQdWJsaWMgUHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw05NjAxMjkwMDAwMDBaFw0wNDAxMDcyMzU5NTlaMF8xCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjE3MDUGA1UECxMuQ2xhc3MgMiBQdWJsaWMgUHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAtlqLow1qI4OAa885h/QhEzMGTCWi7VUSl8WngLn6g8EgoPovFQ18oWBrfnks+gYPOq72G2+x0v8vKFJfg31LxHq3+GYfgFT8t8KOWUoUV0bRmpO+QZEDuxWAk1zr58wIbD8+s0r8/0tsI9VQgiZEGY4jw3HqGSRHBJ51v8imAB8CAwEAATANBgkqhkiG9w0BAQIFAAOBgQC2AB+TV6QHp0DOZUA/VV7t7/pUSaUw1iF8YYfug5MLv7Qz8pisnwa/TqjOFIFMywROWMPPX+5815pvy0GKt3+BuP+EYcYnQ2UdDOyxAArdG6S7x3ggKLKi3TaVLuFUT79guXdoEZkj6OpS6KoATmdOu5C1RZtG644W78QzWzM91Q==\n-----END CERTIFICATE-----\n";
    public static final String Verisign_class3 = "-----BEGIN CERTIFICATE-----\nMIICPTCCAaYCEQDknv3zOugOz6URPhmkJAIyMA0GCSqGSIb3DQEBAgUAMF8xCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjE3MDUGA1UECxMuQ2xhc3MgMyBQdWJsaWMgUHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw05NjAxMjkwMDAwMDBaFw0wNDAxMDcyMzU5NTlaMF8xCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjE3MDUGA1UECxMuQ2xhc3MgMyBQdWJsaWMgUHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAyVxZnvIbigEUtBDfBEDb41evakVAj4QMC9Ez2dkRz+4CWB8l9yqoRAWq7AMfeH+ek7maAKojfdashaJjRcdyJ8z0TMZ1cdI5709C8HXfCpDGjiBvmA/4rCNfcCk2pMmG57GaIMtTpYXnPb59mv4kRTPcdhXtD6JxZExlLoFoRacCAwEAATANBgkqhkiG9w0BAQIFAAOBgQBhcOwvP579K+ZoVCGwZ3kIDCCWMYoNer62Jt95LCJpSTbjl3diYaIy13pUITa6Ask05yXaRDWw0lyAXbOU+Pms7qRgdSoflUkjsUp89LNHciFbfperVKxi513srpvSybIk+4Kt6WcVS7qqpvCXoPawl1cAyAw8CaCCBLpB2veZpA==\n-----END CERTIFICATE-----\n";
    public static final String GTECyberTrustRoot = "-----BEGIN CERTIFICATE-----\nMIIB+jCCAWMCAgGjMA0GCSqGSIb3DQEBBAUAMEUxCzAJBgNVBAYTAlVTMRgwFgYDVQQKEw9HVEUgQ29ycG9yYXRpb24xHDAaBgNVBAMTE0dURSBDeWJlclRydXN0IFJvb3QwHhcNOTYwMjIzMjMwMTAwWhcNMDYwMjIzMjM1OTAwWjBFMQswCQYDVQQGEwJVUzEYMBYGA1UEChMPR1RFIENvcnBvcmF0aW9uMRwwGgYDVQQDExNHVEUgQ3liZXJUcnVzdCBSb290MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQC45k+625h8cXyvRLfTD0bZZOWTwUKOx7pJjTUteueLveUFMVnGsS8KDPufpz+iCWaEVh43KRuH6X4MypqfpX/1FZSj1aJGgthoTNE3FQZor734sLPwKfWVWgkWYXcKIiXUT0Wqx73llt/51KiOQswkwB6RJ0q1bQaAYznEol44AwIDAQABMA0GCSqGSIb3DQEBBAUAA4GBABKzdcZfHeFhVYAA1IFLezEPI2PnPfMD+fQ2qLvZ46WXTeorKeDWanOB5sCJo9Px4KWlIjeaY8JIILTbcuPI9tl8vrGvU9oUtCG41tWW4/5ODFlitppK+ULdjG+BqXH/9ApybW1EDp3zdHSo1TRJ6V6e6bR64eVaH4QwnNOfpSXY\n-----END CERTIFICATE-----\n";
    public static final String GTECyberTrustGlobalRoot = "-----BEGIN CERTIFICATE-----\nMIICWjCCAcMCAgGlMA0GCSqGSIb3DQEBBAUAMHUxCzAJBgNVBAYTAlVTMRgwFgYDVQQKEw9HVEUgQ29ycG9yYXRpb24xJzAlBgNVBAsTHkdURSBDeWJlclRydXN0IFNvbHV0aW9ucywgSW5jLjEjMCEGA1UEAxMaR1RFIEN5YmVyVHJ1c3QgR2xvYmFsIFJvb3QwHhcNOTgwODEzMDAyOTAwWhcNMTgwODEzMjM1OTAwWjB1MQswCQYDVQQGEwJVUzEYMBYGA1UEChMPR1RFIENvcnBvcmF0aW9uMScwJQYDVQQLEx5HVEUgQ3liZXJUcnVzdCBTb2x1dGlvbnMsIEluYy4xIzAhBgNVBAMTGkdURSBDeWJlclRydXN0IEdsb2JhbCBSb290MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCVD6C28FCc6HrHiM3dFw4usJTQGz0O9pTAipTHBsiQl8i4ZBp6fmw8U+E3KHNgf7KXUwefU/ltWJTSr41tiGeA5u2ylc9yMcqlHHK6XALnZELn+aks1joNrI1CqiQBOeacPwGFVw1Yh0X404Wqk2kmhXBIgD8SFcd5tB8FLztimQIDAQABMA0GCSqGSIb3DQEBBAUAA4GBAG3rGwnpXtlR22ciYaQqPEh346B8pt5zohQDhT37qw4wxYMWM4ETCJ57NE7fQMh017l93PR2VX2bY1QY6fDq81yx2YtCHrnAlU66+tXifPVoYb+O7AWXX1uw16OFNMQkpw0PlZPvy5TYnh+dXIVtx6quTx8itc2VrbqnzPmrC3p/\n-----END CERTIFICATE-----\n";
    public static final String tempOurCA = "-----BEGIN CERTIFICATE-----\nMIICjjCCAfegAwIBAgIBATANBgkqhkiG9w0BAQQFADBrMQswCQYDVQQGEwJVUzEPMA0GA1UEChMGT3JhY2xlMSgwJgYDVQQLEx9FbnRlcnByaXNlIEFwcGxpY2F0aW9uIFNlcnZpY2VzMSEwHwYDVQQDExhFQVNRQSBDZXJ0aWZpY2F0ZSBTZXJ2ZXIwHhcNOTgwNDE1MDA0NTQ1WhcNMDAwNDE0MDA0NTQ1WjBrMQswCQYDVQQGEwJVUzEPMA0GA1UEChMGT3JhY2xlMSgwJgYDVQQLEx9FbnRlcnByaXNlIEFwcGxpY2F0aW9uIFNlcnZpY2VzMSEwHwYDVQQDExhFQVNRQSBDZXJ0aWZpY2F0ZSBTZXJ2ZXIwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBANi0bMVLgXMLZZKPg89YhtZ23vtbq2DV7ofReEqvki4Xz9Vvua24YAi3qduCwfLWpznjSca/kNC9inU417vSq2ckpmtrfYgBI+4BbOM9/Moc8491hOmJXyQLJ+Gbhhijp/i/AZ6S/UEApwSJdNV40EIat1zSiuiGPtIa7sscekBTAgMBAAGjQjBAMB0GA1UdDgQWBBQMIfAS4l8gVcNru25g07xs7DURjDAfBgNVHSMEGDAWgBQMIfAS4l8gVcNru25g07xs7DURjDANBgkqhkiG9w0BAQQFAAOBgQDJL7u3HvNdtbeeA/MoMNoFet3Rat89/Im1lukJRZ5MMm+a45c9LdwXAfbPr2PgNvwEUH6g4eVRVBwi2Nel+yp8bmui8MC50g/5uVB72g/5wGbzvt8VxSeQ84muzi91dhZlwVEt6WV8Qkc7m7+R5Y2h56gcL87gxJx6cwoUBjjqQg==-----END CERTIFICATE-----\n";
    public static final String EntrustPremiumCA = "-----BEGIN CERTIFICATE-----\nMIIEXDCCA0SgAwIBAgIEOGO5ZjANBgkqhkiG9w0BAQUFADCBtDEUMBIGA1UEChMLRW50cnVzdC5uZXQxQDA+BgNVBAsUN3d3dy5lbnRydXN0Lm5ldC9DUFNfMjA0OCBpbmNvcnAuIGJ5IHJlZi4gKGxpbWl0cyBsaWFiLikxJTAjBgNVBAsTHChjKSAxOTk5IEVudHJ1c3QubmV0IExpbWl0ZWQxMzAxBgNVBAMTKkVudHJ1c3QubmV0IENlcnRpZmljYXRpb24gQXV0aG9yaXR5ICgyMDQ4KTAeFw05OTEyMjQxNzUwNTFaFw0xOTEyMjQxODIwNTFaMIG0MRQwEgYDVQQKEwtFbnRydXN0Lm5ldDFAMD4GA1UECxQ3d3d3LmVudHJ1c3QubmV0L0NQU18yMDQ4IGluY29ycC4gYnkgcmVmLiAobGltaXRzIGxpYWIuKTElMCMGA1UECxMcKGMpIDE5OTkgRW50cnVzdC5uZXQgTGltaXRlZDEzMDEGA1UEAxMqRW50cnVzdC5uZXQgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkgKDIwNDgpMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArU1LqRKGsuqjIAcVFmQqK0vRvwtKTY7tgHalZ7d4QMBzQshowNtTK91euHaYNZOLGp18EzoOH1u3Hs/lJBQesYGpjX24zGtLA/ECDNyrpUAkAH90lKGdCCmziAv1h3edVc3kw37XamSrhRSGlVuXMlBvPci6Zgzj/L24ScF2iUkZ/cCovYmjZy/Gn7xxGWC4LeksyZB2ZnuU4q941mVTXTzWnLLPKQP5L6RQstRIzgUyVYr9smRMDuSYB3Xbf9+5CFVghTAp+XtIpGmG4zU/HoZdenoVve8AjhUiVBcAkCaTvA5JaJG/+EfTnZVCwQ5N328mz8MYIWJmQ3DW1cAH4QIDAQABo3QwcjARBglghkgBhvhCAQEEBAMCAAcwHwYDVR0jBBgwFoAUVeSB0RGAvtiJuQijMfmhJAkWuXAwHQYDVR0OBBYEFFXkgdERgL7YibkIozH5oSQJFrlwMB0GCSqGSIb2fQdBAAQQMA4bCFY1LjA6NC4wAwIEkDANBgkqhkiG9w0BAQUFAAOCAQEAWUesIYSKF8mciVMeuoCFGsY8Tj6xnLZ8xpJdGGQC49MGCBFhfGPjK50xA3B20qMooPS7mmNz7W3lKtvtFKkrxjYR0CvrB4ul2p5cGZ1WEvVUKcgF7bISKo30Axv/55IQh7A6tcOdBTcSo8f0FbnVpDkWm1M6I5HxqIKiaohowXkCIryqptau37AUX7iH0N18f3v/rxzP5tsHrV7bhZ3QKw0z2wTR5klAEyt2+z7pnIkPFc4YsIV4IU9rTw76NmfNB/L/CNDi3tm/Kq+4h4YhPATKt5Rof8886ZjXOP/swNlQ8C5LWK5Gb9Auw2DaclVyvUxFnmG6v4SBkgPR0ml8xQ==-----END CERTIFICATE-----\n";
    public static final String EntrustGlobalCA = "-----BEGIN CERTIFICATE-----\nMIIElTCCA/6gAwIBAgIEOJsRPDANBgkqhkiG9w0BAQQFADCBujEUMBIGA1UEChMLRW50cnVzdC5uZXQxPzA9BgNVBAsUNnd3dy5lbnRydXN0Lm5ldC9TU0xfQ1BTIGluY29ycC4gYnkgcmVmLiAobGltaXRzIGxpYWIuKTElMCMGA1UECxMcKGMpIDIwMDAgRW50cnVzdC5uZXQgTGltaXRlZDE6MDgGA1UEAxMxRW50cnVzdC5uZXQgU2VjdXJlIFNlcnZlciBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw0wMDAyMDQxNzIwMDBaFw0yMDAyMDQxNzUwMDBaMIG6MRQwEgYDVQQKEwtFbnRydXN0Lm5ldDE/MD0GA1UECxQ2d3d3LmVudHJ1c3QubmV0L1NTTF9DUFMgaW5jb3JwLiBieSByZWYuIChsaW1pdHMgbGlhYi4pMSUwIwYDVQQLExwoYykgMjAwMCBFbnRydXN0Lm5ldCBMaW1pdGVkMTowOAYDVQQDEzFFbnRydXN0Lm5ldCBTZWN1cmUgU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDHwV9OcfHO8GCGD9JYf9Mzly0XonUwtZZkJi9ow0SrqHXmAGc0V55lxyKbc+bT3QgON1WqJUaBbL3+qPZ1V1eMkGxKwz6LS0MKyRFWmponIpnPVZ5h2QLifLZ8OAfc439PmrkDQYC2dWcTC5/oVzbIXQA23mYU2m52H083jIITiQIDAQABo4IBpDCCAaAwEQYJYIZIAYb4QgEBBAQDAgAHMIHjBgNVHR8EgdswgdgwgdWggdKggc+kgcwwgckxFDASBgNVBAoTC0VudHJ1c3QubmV0MT8wPQYDVQQLFDZ3d3cuZW50cnVzdC5uZXQvU1NMX0NQUyBpbmNvcnAuIGJ5IHJlZi4gKGxpbWl0cyBsaWFiLikxJTAjBgNVBAsTHChjKSAyMDAwIEVudHJ1c3QubmV0IExpbWl0ZWQxOjA4BgNVBAMTMUVudHJ1c3QubmV0IFNlY3VyZSBTZXJ2ZXIgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkxDTALBgNVBAMTBENSTDEwKwYDVR0QBCQwIoAPMjAwMDAyMDQxNzIwMDBagQ8yMDIwMDIwNDE3NTAwMFowCwYDVR0PBAQDAgEGMB8GA1UdIwQYMBaAFMtswGvjuz7L/CKc/vuLkpyw8m4iMB0GA1UdDgQWBBTLbMBr47s+y/winP77i5KcsPJuIjAMBgNVHRMEBTADAQH/MB0GCSqGSIb2fQdBAAQQMA4bCFY1LjA6NC4wAwIEkDANBgkqhkiG9w0BAQQFAAOBgQBi24GRzsiad0Iv7L0no1MPUBvqTpLwqa+poLpIYcvvyQbvH9X07t9WLebKahlzqlO+krNQAraFJnJj2HVQYnUUt7NQGj/KEQALhUVpbbalrlHhStyCP2yMNLJ3a9kC9n8O6mUE8c1UyrrJzOCE98g+EZfTYAkYvAX/bIkz8OwVDw==-----END CERTIFICATE-----\n";
    public static final String EntrustMainCA = "-----BEGIN CERTIFICATE-----\nMIIE2DCCBEGgAwIBAgIEN0rSQzANBgkqhkiG9w0BAQUFADCBwzELMAkGA1UEBhMCVVMxFDASBgNVBAoTC0VudHJ1c3QubmV0MTswOQYDVQQLEzJ3d3cuZW50cnVzdC5uZXQvQ1BTIGluY29ycC4gYnkgcmVmLiAobGltaXRzIGxpYWIuKTElMCMGA1UECxMcKGMpIDE5OTkgRW50cnVzdC5uZXQgTGltaXRlZDE6MDgGA1UEAxMxRW50cnVzdC5uZXQgU2VjdXJlIFNlcnZlciBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw05OTA1MjUxNjA5NDBaFw0xOTA1MjUxNjM5NDBaMIHDMQswCQYDVQQGEwJVUzEUMBIGA1UEChMLRW50cnVzdC5uZXQxOzA5BgNVBAsTMnd3dy5lbnRydXN0Lm5ldC9DUFMgaW5jb3JwLiBieSByZWYuIChsaW1pdHMgbGlhYi4pMSUwIwYDVQQLExwoYykgMTk5OSBFbnRydXN0Lm5ldCBMaW1pdGVkMTowOAYDVQQDEzFFbnRydXN0Lm5ldCBTZWN1cmUgU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGdMA0GCSqGSIb3DQEBAQUAA4GLADCBhwKBgQDNKIM0VBuJ8w+vN5Ex/68xYMmo6LIQaO2f55M28Qpku0f1BBc/I0dNxScZgSYMVHINiC3ZH5oSn7yzcdOAGT9HZnuMNSjSuQrfJNqc1lB5gXpa0zf3wkrYKZImZNHkmGw6AIr1NJtl+O3jEP/9uElY3KDegjlrgbEWGWG5VLbmQwIBA6OCAdcwggHTMBEGCWCGSAGG+EIBAQQEAwIABzCCARkGA1UdHwSCARAwggEMMIHeoIHboIHYpIHVMIHSMQswCQYDVQQGEwJVUzEUMBIGA1UEChMLRW50cnVzdC5uZXQxOzA5BgNVBAsTMnd3dy5lbnRydXN0Lm5ldC9DUFMgaW5jb3JwLiBieSByZWYuIChsaW1pdHMgbGlhYi4pMSUwIwYDVQQLExwoYykgMTk5OSBFbnRydXN0Lm5ldCBMaW1pdGVkMTowOAYDVQQDEzFFbnRydXN0Lm5ldCBTZWN1cmUgU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MQ0wCwYDVQQDEwRDUkwxMCmgJ6AlhiNodHRwOi8vd3d3LmVudHJ1c3QubmV0L0NSTC9uZXQxLmNybDArBgNVHRAEJDAigA8xOTk5MDUyNTE2MDk0MFqBDzIwMTkwNTI1MTYwOTQwWjALBgNVHQ8EBAMCAQYwHwYDVR0jBBgwFoAU8BdiE1U9s/8KAGv7UISX8+1i0BowHQYDVR0OBBYEFPAXYhNVPbP/CgBr+1CEl/PtYtAaMAwGA1UdEwQFMAMBAf8wGQYJKoZIhvZ9B0EABAwwChsEVjQuMAMCBJAwDQYJKoZIhvcNAQEFBQADgYEAkNwwAvpkdMKnCqV8IY00F6j7Rw7/JXyNEwr75Ji174z4xRAN95K+8cPV1ZVqBLssziY2ZcgxxufuP+NXdYR6Ee9GTxj005i7qIcyunL2POI9n9cd2cNgQ4xYDiKWL2KjLB+6rQXvqzJ4h6BUcxm1XAX5Uj5tLUUL9wqT6u0G+bI=-----END CERTIFICATE-----\n";

    public NZWallet(String string) throws NZException {
        this.myWltPtr = NZNative.createWallet();
        this.setWallet(this.myWltPtr, string);
    }

    private NZWallet(byte[] byArray, String string) throws NZException {
        if (byArray == null) {
            throw new NZException("Wallet Ptr is NULL.");
        }
        this.setWallet(byArray, string);
    }

    private boolean setWallet(byte[] byArray, String string) throws NZException {
        this.myPassword = string;
        WalletCache walletCache = NZNative.getWalletCache(byArray);
        this.myLdapDN = walletCache.myLdapDN;
        this.mySecurePolicy = walletCache.mySecurePolicy;
        this.myOpenPolicy = walletCache.myOpenPolicy;
        this.myWltPtr = byArray;
        this.myPersonaVec = this.createPersonaVec(byArray);
        return true;
    }

    private Vector createPersonaVec(byte[] byArray) throws NZException {
        Vector<NZPersona> vector = new Vector<NZPersona>();
        Enumeration enumeration = NZNative.getWalletPersonas(byArray);
        while (enumeration.hasMoreElements()) {
            NZPersona nZPersona = new NZPersona((byte[])enumeration.nextElement());
            vector.addElement(nZPersona);
        }
        return vector;
    }

    public boolean installB64Cert(NZPersona nZPersona, String string, String string2) throws NZException {
        if (!(string.equals("NZDST_CERTIFICATE") || string.equals("NZDST_CLEAR_ETP") || string.equals("NZDST_CLEAR_UTP") || string.equals("NZDST_CLEAR_PTP"))) {
            throw new NZException("Unknown Certificate Identity Type.");
        }
        NZNative.installB64CertInWallet(this.myWltPtr, nZPersona.getPersonaPtr(), string, string2);
        this.setWallet(this.myWltPtr, this.myPassword);
        return true;
    }

    public boolean deleteCertOrTP(NZPersona nZPersona, NZCertificate nZCertificate) throws NZException {
        String string = nZCertificate.getIdentityType();
        if (!(string.equals("NZDST_CERTIFICATE") || string.equals("NZDST_CLEAR_ETP") || string.equals("NZDST_CLEAR_UTP") || string.equals("NZDST_CLEAR_PTP"))) {
            throw new NZException("Unknown Certificate Identity Type.");
        }
        boolean bl = NZNative.deleteCertOrTPFromWallet(this.myWltPtr, nZPersona.getPersonaPtr(), nZCertificate.getIdentityPtr());
        this.setWallet(this.myWltPtr, this.myPassword);
        return bl;
    }

    protected void finalize() {
        AdminTRACE.out("In Wallet.finalize()...");
        this.freeWalletCMem();
    }

    public void freeWalletCMem() {
        AdminTRACE.out("In Wallet.freeWalletCMem()...");
        if (this.myWltPtr != null) {
            NZNative.destroyWallet(this.myWltPtr);
            this.myWltPtr = null;
            this.myPersonaVec.removeAllElements();
        }
    }

    public boolean setWRL(String string) {
        this.myWrl = string;
        return true;
    }

    public boolean setRioType(int n) {
        this.myRioType = n;
        return true;
    }

    public boolean setLdapDN(String string) {
        this.myLdapDN = string;
        return true;
    }

    public boolean setPassword(String string) {
        this.myPassword = string;
        return true;
    }

    public String getWRL() {
        return this.myWrl;
    }

    public int getRioType() {
        return this.myRioType;
    }

    public String getLdapDN() {
        return this.myLdapDN;
    }

    public int getSecPolicy() {
        return this.mySecurePolicy;
    }

    public int getOpenPolicy() {
        return this.myOpenPolicy;
    }

    public String getPassword() {
        return this.myPassword;
    }

    public int getPersonaCount(int n) {
        return this.myPersonaVec.size();
    }

    public NZPersona getPersonabyIndex(int n) {
        return (NZPersona)this.myPersonaVec.elementAt(n);
    }

    public NZPersona getPersonabyName(String string) {
        NZPersona nZPersona = null;
        int n = 0;
        while (n < this.myPersonaVec.size()) {
            nZPersona = (NZPersona)this.myPersonaVec.elementAt(n);
            String string2 = nZPersona.getName();
            if (string.equals(string2)) {
                return nZPersona;
            }
            ++n;
        }
        AdminTRACE.out("No persona of this name => " + string);
        return null;
    }

    public static String getDefaultWRL() throws NZException {
        return NZNative.getDefaultWRL();
    }

    public static boolean isSSLLibDomestic() {
        return NZNative.isLibDomestic();
    }

    public boolean addPersona(byte[] byArray) throws NZException {
        throw new NZException("Unsupported method");
    }

    public boolean removePersona(String string) throws NZException {
        throw new NZException("Unsupported method");
    }

    public static NZWallet loadWallet(String string, String string2) throws NZException {
        byte[] byArray = NZNative.loadWallet(string, string2);
        NZWallet nZWallet = new NZWallet(byArray, string2);
        return nZWallet;
    }

    public boolean storeWallet() throws NZException {
        if (this.myWrl == null) {
            throw new NZException("Store Location (WRL) not set !");
        }
        if (this.myWltPtr == null) {
            throw new NZException("Wallet ptr is NULL !");
        }
        return NZNative.storeWallet(this.myWltPtr, this.myWrl, this.myPassword);
    }

    public boolean storeSSOWallet() throws NZException {
        if (this.myWrl == null) {
            throw new NZException("Store Location (WRL) not set !");
        }
        if (this.myWltPtr == null) {
            throw new NZException("Wallet ptr is NULL !");
        }
        return NZNative.storeSSOWallet(this.myWltPtr, this.myWrl, this.myPassword);
    }

    public String toString() {
        String string = "myWrl:" + this.myWrl + "\nmyRioType:" + this.myRioType + "\nmyLdapDN:" + this.myLdapDN + "\nmySecurePolicy:" + this.mySecurePolicy + "\nmyOpenPolicy:" + this.myOpenPolicy;
        string = String.valueOf(string) + "\t Printing Personas..\n";
        Enumeration enumeration = this.myPersonaVec.elements();
        while (enumeration.hasMoreElements()) {
            string = String.valueOf(string) + ((NZPersona)enumeration.nextElement()).toString();
        }
        return string;
    }
}

