/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.admin.util;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;
import oracle.ewt.EwtContainer;
import oracle.ewt.UIManager;
import oracle.ewt.border.Border;
import oracle.ewt.border.FrameBorder;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.graphics.Appearance;
import oracle.ewt.graphics.frame.LoweredFramePainter;
import oracle.ewt.grid.AppearanceManager;
import oracle.ewt.grid.BooleanInputHandler;
import oracle.ewt.grid.CellInputHandler;
import oracle.ewt.grid.CheckPainter;
import oracle.ewt.grid.ComplexAppearanceManager;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridCellSelectListener;
import oracle.ewt.grid.GridEvent;
import oracle.ewt.grid.GridSelection;
import oracle.ewt.grid.TextFieldInputHandler;
import oracle.ewt.header.Header;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.painter.FixedAlignmentPainter;
import oracle.ewt.painter.ImagePainter;
import oracle.ewt.painter.Painter;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.security.admin.util.AdminGridGUIComponent;
import oracle.security.admin.util.AdminTRACE;

public class AdminGridHelper
implements ComponentListener,
GridCellSelectListener,
TextListener {
    private TextFieldInputHandler m_columnInputHandler;
    private BooleanInputHandler m_checkBoxInputHandler;
    private LWTextField m_columnInputField;
    private GridEvent m_lastGridSelectionEvent;
    private String[] m_selection;
    private Grid m_thisGrid;
    private int m_gridType;
    private int m_gridHeaderLength;
    private Header gridHeader;
    private int IMAGE_COL_WIDTH = 22;
    private AdminGridGUIComponent m_guiComponent;
    public static int CUSTOM_GRID_TWO_COLUMN_EDIT;
    public static int CUSTOM_GRID_TWO_COLUMN_TWO_EDIT;
    public static int CUSTOM_GRID_ONE_COLUMN_LIST;
    public static int CUSTOM_GRID_THREE_COLUMN_TWO_EDIT;
    public static int CUSTOM_GRID_FOUR_COLUMN_TWO_EDIT;

    public AdminGridHelper(AdminGridGUIComponent adminGridGUIComponent) {
        this.m_guiComponent = adminGridGUIComponent;
    }

    public EwtContainer getImageGridPanel(GridBagLayout gridBagLayout, Grid grid, String string, String[] stringArray) {
        EwtContainer ewtContainer = new EwtContainer();
        ewtContainer.setLayout(gridBagLayout);
        String string2 = string;
        ewtContainer.setBorderPainter(UIManager.createGroupBoxPainter((String)string2));
        this.gridHeader = this.getGridHeader(stringArray);
        this.setColumnsWidth();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        ((GridBagLayout)ewtContainer.getLayout()).setConstraints((Component)this.gridHeader, gridBagConstraints);
        ewtContainer.add((Component)this.gridHeader);
        ScrollBox scrollBox = new ScrollBox((Component)grid, 0, 0);
        scrollBox.setBorder((Border)new FrameBorder(2, LoweredFramePainter.getFramePainter()));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        ((GridBagLayout)ewtContainer.getLayout()).setConstraints((Component)scrollBox, gridBagConstraints);
        ewtContainer.add((Component)scrollBox);
        return ewtContainer;
    }

    private Header getGridHeader(String[] stringArray) {
        int n;
        OneDDataSource oneDDataSource = this.m_guiComponent.buildHeaderOneDDataSource(stringArray);
        Header header = new Header(oneDDataSource, true);
        this.m_gridHeaderLength = n = oneDDataSource.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            header.setItemMovable(n2, false);
            header.setItemResizable(n2, false);
            ++n2;
        }
        return header;
    }

    private Grid createTwoColumnEditGrid(TwoDDataSource twoDDataSource) throws Exception {
        Grid grid = new Grid(twoDDataSource);
        grid.setDefaultRowHeight(20);
        if (AdminTRACE.m_CurrentTraceLevel <= 0) {
            System.out.println("AdminGridHelper: createAttributeGrid: new grid set..");
        }
        grid.addComponentListener(this);
        grid.addCellSelectListener((GridCellSelectListener)this);
        grid.setDrawFocusCellHighlite(false);
        grid.setHorizontalSeparatorsVisible(true);
        grid.setVerticalSeparatorsVisible(true);
        this.m_columnInputHandler = (TextFieldInputHandler)TextFieldInputHandler.getCellInputHandler();
        this.m_columnInputField = this.m_columnInputHandler.getLWTextField();
        this.m_columnInputField.addTextListener((TextListener)this);
        grid.setColumnCellInputHandler(2, (CellInputHandler)this.m_columnInputHandler);
        grid.setColumnPainter(0, (Painter)new FixedAlignmentPainter((Painter)new ImagePainter(null, 0)));
        ComplexAppearanceManager complexAppearanceManager = new ComplexAppearanceManager();
        grid.setAppearanceManager((AppearanceManager)complexAppearanceManager);
        Appearance appearance = complexAppearanceManager.getColumnAppearance(0);
        appearance.setHorizontalJustify(3);
        Appearance appearance2 = complexAppearanceManager.getColumnAppearance(2);
        appearance2.setHorizontalJustify(1);
        return grid;
    }

    private Grid createTwoColumnTwoEditGrid(TwoDDataSource twoDDataSource) throws Exception {
        Grid grid = new Grid(twoDDataSource);
        grid.setDefaultRowHeight(20);
        if (AdminTRACE.m_CurrentTraceLevel <= 0) {
            System.out.println("AdminGridHelper: createAttributeGrid: new grid set..");
        }
        grid.addComponentListener(this);
        grid.addCellSelectListener((GridCellSelectListener)this);
        grid.setDrawFocusCellHighlite(false);
        grid.setHorizontalSeparatorsVisible(true);
        grid.setVerticalSeparatorsVisible(true);
        this.m_columnInputHandler = (TextFieldInputHandler)TextFieldInputHandler.getCellInputHandler();
        this.m_columnInputField = this.m_columnInputHandler.getLWTextField();
        this.m_columnInputField.addTextListener((TextListener)this);
        grid.setColumnCellInputHandler(1, (CellInputHandler)this.m_columnInputHandler);
        grid.setColumnCellInputHandler(2, (CellInputHandler)this.m_columnInputHandler);
        grid.setColumnPainter(0, (Painter)new FixedAlignmentPainter((Painter)new ImagePainter(null, 0)));
        ComplexAppearanceManager complexAppearanceManager = new ComplexAppearanceManager();
        grid.setAppearanceManager((AppearanceManager)complexAppearanceManager);
        Appearance appearance = complexAppearanceManager.getColumnAppearance(0);
        appearance.setHorizontalJustify(3);
        Appearance appearance2 = complexAppearanceManager.getColumnAppearance(2);
        appearance2.setHorizontalJustify(1);
        return grid;
    }

    private Grid createThreeColumnTwoEditGrid(TwoDDataSource twoDDataSource) throws Exception {
        Grid grid = new Grid(twoDDataSource);
        grid.setDefaultRowHeight(20);
        if (AdminTRACE.m_CurrentTraceLevel <= 0) {
            System.out.println("AdminGridHelper: createAttributeGrid: new grid set..");
        }
        grid.addComponentListener(this);
        grid.addCellSelectListener((GridCellSelectListener)this);
        grid.setDrawFocusCellHighlite(false);
        grid.setHorizontalSeparatorsVisible(true);
        grid.setVerticalSeparatorsVisible(true);
        this.m_columnInputHandler = (TextFieldInputHandler)TextFieldInputHandler.getCellInputHandler();
        this.m_columnInputField = this.m_columnInputHandler.getLWTextField();
        this.m_checkBoxInputHandler = (BooleanInputHandler)BooleanInputHandler.getCellInputHandler();
        this.m_columnInputField.addTextListener((TextListener)this);
        grid.setColumnCellInputHandler(1, (CellInputHandler)this.m_columnInputHandler);
        grid.setColumnCellInputHandler(2, (CellInputHandler)this.m_columnInputHandler);
        grid.setColumnCellInputHandler(3, (CellInputHandler)this.m_checkBoxInputHandler);
        grid.setColumnPainter(0, (Painter)new FixedAlignmentPainter((Painter)new ImagePainter(null, 0)));
        CheckPainter checkPainter = (CheckPainter)CheckPainter.getPainter();
        grid.setColumnPainter(3, (Painter)new FixedAlignmentPainter((Painter)checkPainter));
        ComplexAppearanceManager complexAppearanceManager = new ComplexAppearanceManager();
        grid.setAppearanceManager((AppearanceManager)complexAppearanceManager);
        Appearance appearance = complexAppearanceManager.getColumnAppearance(0);
        appearance.setHorizontalJustify(3);
        Appearance appearance2 = complexAppearanceManager.getColumnAppearance(2);
        appearance2.setHorizontalJustify(1);
        return grid;
    }

    private Grid createFourColumnTwoEditGrid(TwoDDataSource twoDDataSource) throws Exception {
        Grid grid = new Grid(twoDDataSource);
        grid.setDefaultRowHeight(20);
        if (AdminTRACE.m_CurrentTraceLevel <= 0) {
            System.out.println("AdminGridHelper: createAttributeGrid: new grid set..");
        }
        grid.addComponentListener(this);
        grid.addCellSelectListener((GridCellSelectListener)this);
        grid.setDrawFocusCellHighlite(false);
        grid.setHorizontalSeparatorsVisible(true);
        grid.setVerticalSeparatorsVisible(true);
        this.m_columnInputHandler = (TextFieldInputHandler)TextFieldInputHandler.getCellInputHandler();
        this.m_columnInputField = this.m_columnInputHandler.getLWTextField();
        this.m_checkBoxInputHandler = (BooleanInputHandler)BooleanInputHandler.getCellInputHandler();
        this.m_columnInputField.addTextListener((TextListener)this);
        grid.setColumnCellInputHandler(1, (CellInputHandler)this.m_columnInputHandler);
        grid.setColumnCellInputHandler(2, (CellInputHandler)this.m_columnInputHandler);
        grid.setColumnCellInputHandler(3, (CellInputHandler)this.m_checkBoxInputHandler);
        grid.setColumnCellInputHandler(4, (CellInputHandler)this.m_checkBoxInputHandler);
        grid.setColumnPainter(0, (Painter)new FixedAlignmentPainter((Painter)new ImagePainter(null, 0)));
        CheckPainter checkPainter = (CheckPainter)CheckPainter.getPainter();
        grid.setColumnPainter(3, (Painter)new FixedAlignmentPainter((Painter)checkPainter));
        CheckPainter checkPainter2 = (CheckPainter)CheckPainter.getPainter();
        grid.setColumnPainter(4, (Painter)new FixedAlignmentPainter((Painter)checkPainter2));
        ComplexAppearanceManager complexAppearanceManager = new ComplexAppearanceManager();
        grid.setAppearanceManager((AppearanceManager)complexAppearanceManager);
        Appearance appearance = complexAppearanceManager.getColumnAppearance(0);
        appearance.setHorizontalJustify(3);
        Appearance appearance2 = complexAppearanceManager.getColumnAppearance(2);
        appearance2.setHorizontalJustify(1);
        return grid;
    }

    private Grid createOneColumnListGrid(TwoDDataSource twoDDataSource) throws Exception {
        Grid grid = new Grid(twoDDataSource);
        grid.setDefaultRowHeight(20);
        if (AdminTRACE.m_CurrentTraceLevel <= 0) {
            System.out.println("AdminGridHelper: createListGrid: new grid set..");
        }
        grid.addComponentListener(this);
        grid.addCellSelectListener((GridCellSelectListener)this);
        grid.setDrawFocusCellHighlite(false);
        grid.setHorizontalSeparatorsVisible(false);
        grid.setVerticalSeparatorsVisible(false);
        grid.setColumnPainter(0, (Painter)new FixedAlignmentPainter((Painter)new ImagePainter(null, 0)));
        ComplexAppearanceManager complexAppearanceManager = new ComplexAppearanceManager();
        grid.setAppearanceManager((AppearanceManager)complexAppearanceManager);
        Appearance appearance = complexAppearanceManager.getColumnAppearance(0);
        appearance.setHorizontalJustify(3);
        return grid;
    }

    public Grid createCustomGrid(TwoDDataSource twoDDataSource, int n) throws Exception {
        if (n == CUSTOM_GRID_TWO_COLUMN_EDIT) {
            this.m_thisGrid = this.createTwoColumnEditGrid(twoDDataSource);
            this.m_gridType = CUSTOM_GRID_TWO_COLUMN_EDIT;
        } else if (n == CUSTOM_GRID_TWO_COLUMN_TWO_EDIT) {
            this.m_thisGrid = this.createTwoColumnTwoEditGrid(twoDDataSource);
            this.m_gridType = CUSTOM_GRID_TWO_COLUMN_TWO_EDIT;
        } else if (n == CUSTOM_GRID_THREE_COLUMN_TWO_EDIT) {
            this.m_thisGrid = this.createThreeColumnTwoEditGrid(twoDDataSource);
            this.m_gridType = CUSTOM_GRID_THREE_COLUMN_TWO_EDIT;
        } else if (n == CUSTOM_GRID_FOUR_COLUMN_TWO_EDIT) {
            this.m_thisGrid = this.createFourColumnTwoEditGrid(twoDDataSource);
            this.m_gridType = CUSTOM_GRID_FOUR_COLUMN_TWO_EDIT;
        } else if (n == CUSTOM_GRID_ONE_COLUMN_LIST) {
            this.m_thisGrid = this.createOneColumnListGrid(twoDDataSource);
            this.m_gridType = CUSTOM_GRID_ONE_COLUMN_LIST;
        } else {
            this.m_thisGrid = null;
        }
        return this.m_thisGrid;
    }

    public String[][] getTwoColumnEditGridValues(Grid grid) {
        String[][] stringArray = null;
        TwoDDataSource twoDDataSource = grid.getDataSource();
        int n = twoDDataSource.getRowCount();
        Vector<String[]> vector = new Vector<String[]>();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)twoDDataSource.getData(1, n2);
            String string2 = (String)twoDDataSource.getData(2, n2);
            if (string2 != null && string2.length() != 0) {
                String[] stringArray2 = new String[]{string, string2};
                vector.addElement(stringArray2);
            }
            ++n2;
        }
        int n3 = vector.size();
        if (n3 > 0) {
            stringArray = new String[2][n3];
            vector.copyInto((Object[])stringArray);
        }
        return stringArray;
    }

    private void setColumnsWidth() {
        int n;
        int n2 = (this.m_thisGrid.getInnerSize().width - this.IMAGE_COL_WIDTH + 5) / 3;
        if (this.gridHeader == null) {
            if (AdminTRACE.m_CurrentTraceLevel <= 0) {
                System.out.println("AdminGridHelper: setColumnsWidth: bad gridHeader!");
            }
        } else if (this.m_gridHeaderLength == 1) {
            this.gridHeader.setItemSize(0, 3 * n2);
        } else if (this.m_gridHeaderLength == 2) {
            this.gridHeader.setItemSize(0, n2 + this.IMAGE_COL_WIDTH);
            this.gridHeader.setItemSize(1, 2 * n2);
        } else if (this.m_gridHeaderLength == 3) {
            this.gridHeader.setItemSize(0, n2 + this.IMAGE_COL_WIDTH);
            this.gridHeader.setItemSize(1, n2);
            this.gridHeader.setItemSize(2, n2);
        } else if (this.m_gridHeaderLength == 4) {
            n = n2 / 2;
            this.gridHeader.setItemSize(0, n2 + this.IMAGE_COL_WIDTH);
            this.gridHeader.setItemSize(1, n2);
            this.gridHeader.setItemSize(2, n);
            this.gridHeader.setItemSize(3, n);
        }
        n = this.m_thisGrid.getColumnCount();
        String string = "setColumnsWidth: grid has [" + n + "] columns";
        String string2 = "AdminGridHelper: " + string;
        if (AdminTRACE.m_CurrentTraceLevel <= 0) {
            System.out.println(string2);
        }
        if (this.m_thisGrid == null) {
            if (AdminTRACE.m_CurrentTraceLevel <= 0) {
                System.out.println("AdminGridHelper: setColumnsWidth: no grid!");
                return;
            }
        } else {
            if (n == 5) {
                this.m_thisGrid.setColumnWidth(0, this.IMAGE_COL_WIDTH);
                int n3 = n2 / 2;
                this.m_thisGrid.setColumnWidth(1, n2 - 5);
                this.m_thisGrid.setColumnWidth(2, n2);
                this.m_thisGrid.setColumnWidth(3, n3);
                this.m_thisGrid.setColumnWidth(3, n3);
                return;
            }
            if (n == 4) {
                this.m_thisGrid.setColumnWidth(0, this.IMAGE_COL_WIDTH);
                int n4 = n2 / 2;
                this.m_thisGrid.setColumnWidth(1, n2 - 5);
                this.m_thisGrid.setColumnWidth(2, n2 + n4);
                this.m_thisGrid.setColumnWidth(3, n4);
                return;
            }
            if (n == 3) {
                this.m_thisGrid.setColumnWidth(0, this.IMAGE_COL_WIDTH);
                this.m_thisGrid.setColumnWidth(1, n2 - 5);
                this.m_thisGrid.setColumnWidth(2, 2 * n2);
                return;
            }
            if (n == 2) {
                this.m_thisGrid.setColumnWidth(0, this.IMAGE_COL_WIDTH);
                this.m_thisGrid.setColumnWidth(1, 3 * n2);
                return;
            }
            if (AdminTRACE.m_CurrentTraceLevel <= 0) {
                System.out.println("AdminGridHelper: setColumnsWidth: bad column count!");
            }
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.setColumnsWidth();
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void cellSelecting(GridEvent gridEvent) {
    }

    public void cellDeselected(GridEvent gridEvent) {
        if (gridEvent.getSource() == this.m_thisGrid) {
            this.m_thisGrid.getGridSelection().setCellSelected(gridEvent.getColumn(), gridEvent.getRow(), false);
        }
    }

    public void cellDeselecting(GridEvent gridEvent) {
    }

    public void cellSelected(GridEvent gridEvent) {
        if (gridEvent.getSource() == this.m_thisGrid) {
            String string = "cellSelected! [" + gridEvent.getColumn() + "]..";
            String string2 = "AdminGridHelper: " + string;
            if (AdminTRACE.m_CurrentTraceLevel <= 0) {
                System.out.println(string2);
            }
            if (this.m_gridType == CUSTOM_GRID_TWO_COLUMN_EDIT) {
                this.onTwoColEditGridCellSelected(gridEvent);
                return;
            }
            if (this.m_gridType == CUSTOM_GRID_TWO_COLUMN_TWO_EDIT) {
                this.onMultiEditGridCellSelected(gridEvent);
                return;
            }
            if (this.m_gridType == CUSTOM_GRID_THREE_COLUMN_TWO_EDIT) {
                this.onMultiEditGridCellSelected(gridEvent);
                return;
            }
            if (this.m_gridType == CUSTOM_GRID_FOUR_COLUMN_TWO_EDIT) {
                this.onMultiEditGridCellSelected(gridEvent);
                return;
            }
            if (this.m_gridType == CUSTOM_GRID_ONE_COLUMN_LIST) {
                this.onOneColListGridCellSelected(gridEvent);
            }
        }
    }

    private void onTwoColEditGridCellSelected(GridEvent gridEvent) {
        GridSelection gridSelection = this.m_thisGrid.getGridSelection();
        int n = gridEvent.getColumn();
        int n2 = gridEvent.getRow();
        this.m_lastGridSelectionEvent = gridEvent;
        String string = "onTwoColEditGridCellSelected: row [" + n2 + "] col [" + n + "]..";
        String string2 = "AdminGridHelper: " + string;
        if (AdminTRACE.m_CurrentTraceLevel <= 0) {
            System.out.println(string2);
        }
        if (n == 2) {
            if (AdminTRACE.m_CurrentTraceLevel <= 0) {
                System.out.println("AdminGridHelper: onAttributeGridColSelected: select cell @ column 2..");
            }
            gridSelection.setCellSelected(n, n2, true);
            return;
        }
        gridSelection.setCellSelected(n, n2, false);
    }

    private void onMultiEditGridCellSelected(GridEvent gridEvent) {
        GridSelection gridSelection = this.m_thisGrid.getGridSelection();
        int n = gridEvent.getColumn();
        int n2 = gridEvent.getRow();
        this.m_lastGridSelectionEvent = gridEvent;
        String string = "onMultiColEditGridCellSelected: row [" + n2 + "] col [" + n + "]..";
        String string2 = "AdminGridHelper: " + string;
        if (AdminTRACE.m_CurrentTraceLevel <= 0) {
            System.out.println(string2);
        }
        if (n == 1 || n == 2) {
            gridSelection.setCellSelected(n, n2, true);
            this.m_guiComponent.onSetCellSelected(n, n2);
            return;
        }
        if (n == 3 || n == 4) {
            gridSelection.setCellSelected(n, n2, false);
            this.onChangedBooleanColumn();
            return;
        }
        gridSelection.setCellSelected(n, n2, false);
    }

    private void onOneColListGridCellSelected(GridEvent gridEvent) {
        GridSelection gridSelection = this.m_thisGrid.getGridSelection();
        TwoDDataSource twoDDataSource = this.m_thisGrid.getDataSource();
        int n = gridEvent.getColumn();
        int n2 = gridEvent.getRow();
        if (n == 1) {
            gridSelection.setCellSelected(n, n2, true);
            Object object = twoDDataSource.getData(n, n2);
            if (object != null) {
                String string = (String)object;
                String[] stringArray = "onOneColListGridCellSelected: [" + string + "]";
                String string2 = "AdminGridHelper: " + (String)stringArray;
                if (AdminTRACE.m_CurrentTraceLevel <= 0) {
                    System.out.println(string2);
                }
                stringArray = new String[]{string};
                this.m_selection = stringArray;
                return;
            }
            if (AdminTRACE.m_CurrentTraceLevel <= 0) {
                System.out.println("AdminGridHelper: onSelectionGridCellSelected: null data!");
                return;
            }
        } else {
            gridSelection.setCellSelected(n, n2, false);
        }
    }

    public String[] getSelection() {
        if (AdminTRACE.m_CurrentTraceLevel <= 0) {
            System.out.println("AdminGridHelper: getSelection: enter..");
        }
        return this.m_selection;
    }

    public void textValueChanged(TextEvent textEvent) {
        if (textEvent.getSource() == this.m_columnInputField) {
            this.onChangedColumnInputField();
        }
    }

    private void onChangedColumnInputField() {
        String string = this.m_columnInputField.getText();
        String string2 = "onChangedColumnInputField [" + string + "]..";
        String string3 = "AdminGridHelper: " + string2;
        if (AdminTRACE.m_CurrentTraceLevel <= 0) {
            System.out.println(string3);
        }
        if (this.m_lastGridSelectionEvent == null) {
            if (AdminTRACE.m_CurrentTraceLevel <= 0) {
                System.out.println("AdminGridHelper: onChangedColumnInputField: last grid select lost!");
                return;
            }
        } else {
            int n = this.m_lastGridSelectionEvent.getRow();
            int n2 = this.m_lastGridSelectionEvent.getColumn();
            String[] stringArray = "value [" + string + "] @ [" + n2 + "][" + n + "]";
            String string4 = "AdminGridHelper: " + (String)stringArray;
            if (AdminTRACE.m_CurrentTraceLevel <= 0) {
                System.out.println(string4);
            }
            if (this.m_guiComponent != null) {
                stringArray = new String[]{string};
                this.m_guiComponent.handleGridRowInputChange(n2, n, stringArray);
            }
        }
    }

    private void onChangedBooleanColumn() {
        if (this.m_lastGridSelectionEvent == null) {
            if (AdminTRACE.m_CurrentTraceLevel <= 0) {
                System.out.println("AdminGridHelper: onChangedColumnInputField: last grid select lost!");
                return;
            }
        } else {
            int n = this.m_lastGridSelectionEvent.getRow();
            int n2 = this.m_lastGridSelectionEvent.getColumn();
            if (this.m_guiComponent != null) {
                this.m_guiComponent.toggleBooleanColumn(n2, n);
            }
        }
    }

    private void debug(String string) {
        String string2 = "AdminGridHelper: " + string;
        if (AdminTRACE.m_CurrentTraceLevel <= 0) {
            System.out.println(string2);
        }
    }

    static {
        CUSTOM_GRID_TWO_COLUMN_TWO_EDIT = 1;
        CUSTOM_GRID_ONE_COLUMN_LIST = 2;
        CUSTOM_GRID_THREE_COLUMN_TWO_EDIT = 3;
        CUSTOM_GRID_FOUR_COLUMN_TWO_EDIT = 4;
    }
}

