/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.admin.wltmgr.owma;

import java.awt.Frame;
import oracle.ewt.alert.Alert;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.security.admin.util.AdminTRACE;
import oracle.security.admin.wltmgr.owma.OwmaDetailComponent;
import oracle.sysman.emSDK.client.appComponent.TreeDetailAppComponent;
import oracle.sysman.emSDK.client.appContainer.ImageLoader;
import oracle.sysman.emSDK.client.appContainer.WebApplication;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.CommandAdapter;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.CommandEvent;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.CommandListener;
import oracle.sysman.emSDK.common.nls.MessageBundle;

public abstract class OwmaBaseCommandHandler
extends CommandAdapter {
    public static final String USER_NAME = "CN=Scott Anderson, OU=security, O=Oracle, C=US";
    public static final String WLT_PASSWD = "ok";
    public static final int PASS_LEN = 1;
    protected WebApplication m_webApp;
    protected OwmaDetailComponent m_app;
    protected BufferedFrame m_frame;
    protected ImageLoader m_imgContainer;
    protected static MessageBundle owmMsgBundle = new MessageBundle("Owm");

    public OwmaBaseCommandHandler(WebApplication webApplication, OwmaDetailComponent owmaDetailComponent) {
        super(webApplication);
        this.m_app = owmaDetailComponent;
        this.m_frame = (BufferedFrame)webApplication.getFrame();
        this.m_webApp = webApplication;
        this.m_imgContainer = webApplication;
        owmMsgBundle.setPackage("oracle.security.resources");
    }

    public void setPopupMenuAdapter(TreeDetailAppComponent treeDetailAppComponent) {
        treeDetailAppComponent.addCommandListener((CommandListener)this, 9501);
        treeDetailAppComponent.addCommandListener((CommandListener)this, 9502);
        treeDetailAppComponent.addCommandListener((CommandListener)this, 9511);
        treeDetailAppComponent.addCommandListener((CommandListener)this, 9512);
        treeDetailAppComponent.addCommandListener((CommandListener)this, 9513);
        treeDetailAppComponent.addCommandListener((CommandListener)this, 9514);
        treeDetailAppComponent.addCommandListener((CommandListener)this, 9521);
        treeDetailAppComponent.addCommandListener((CommandListener)this, 9522);
        treeDetailAppComponent.addCommandListener((CommandListener)this, 9523);
        treeDetailAppComponent.addCommandListener((CommandListener)this, 9524);
        treeDetailAppComponent.addCommandListener((CommandListener)this, 9525);
        treeDetailAppComponent.addCommandListener((CommandListener)this, 9531);
        treeDetailAppComponent.addCommandListener((CommandListener)this, 9541);
        treeDetailAppComponent.addCommandListener((CommandListener)this, 9542);
        treeDetailAppComponent.addCommandListener((CommandListener)this, 9543);
        treeDetailAppComponent.addCommandListener((CommandListener)this, 9551);
        treeDetailAppComponent.addCommandListener((CommandListener)this, 9561);
    }

    public void commandIssued(CommandEvent commandEvent) {
        int n = commandEvent.getCommandId();
        if (n == -1) {
            this.showStatus(" ");
            this.debug("Command: " + commandEvent.getCommand());
            if (commandEvent.getCommand().equals("3016")) {
                this.m_app.showHelpContents();
                return;
            }
            this.handleStandardMenuCommand(commandEvent.getCommand());
            return;
        }
        if (n > 0) {
            this.showStatus(" ");
            this.debug("Command ID:" + n);
            this.handlePopupMenuCommand(n);
        }
    }

    protected void handleStandardMenuCommand(String string) {
        if (string.equals("WALLET_NEW")) {
            this.newWallet();
            return;
        }
        if (string.equals("WALLET_OPEN")) {
            this.openWallet();
            return;
        }
        if (string.equals("WALLET_CLOSE")) {
            this.closeWallet();
            return;
        }
        if (string.equals("WALLET_SAVE")) {
            this.saveWallet();
            return;
        }
        if (string.equals("WALLET_SAVE_AS")) {
            this.saveAsWallet();
            return;
        }
        if (string.equals("WALLET_SAVE_SYS")) {
            this.saveSysWallet();
            return;
        }
        if (string.equals("WALLET_DEL")) {
            this.deleteWallet();
            return;
        }
        if (string.equals("WALLET_PASS")) {
            this.changePassWallet();
            return;
        }
        if (string.equals("WALLET_UPLOAD")) {
            this.uploadWallet();
            return;
        }
        if (string.equals("WALLET_DOWNLOAD")) {
            this.downloadWallet();
            return;
        }
        if (string.equals("WALLET_LOGIN")) {
            this.loginWallet();
            return;
        }
        if (string.equals("WALLET_LOGOUT")) {
            this.logoutWallet();
            return;
        }
        if (string.equals("WALLET_PREF")) {
            this.preferencesWallet();
            return;
        }
        if (string.equals("WALLET_EXP_SSO")) {
            this.exportSsoWallet();
            return;
        }
        if (string.equals("WALLET_EXIT")) {
            this.exitWalletManager();
            return;
        }
        if (string.equals("CERT_CREAT")) {
            this.createCertificateReq();
            return;
        }
        if (string.equals("CERT_IMP")) {
            this.importCertificate();
            return;
        }
        if (string.equals("CERT_IMP_TC")) {
            this.importTrustedCertificate();
            return;
        }
        if (string.equals("WALLET_REF")) {
            this.refreshWallet();
            return;
        }
        if (string.equals("CERT_REM_USERCERT")) {
            this.removeUserCertificate();
            return;
        }
        if (string.equals("CERT_REM_TC")) {
            this.removeTrustedCertificate();
            return;
        }
        if (string.equals("CERT_REM_ETCL")) {
            this.removeEntTCList();
            return;
        }
        if (string.equals("CERT_EXP_UC")) {
            this.exportUserCertificate();
            return;
        }
        if (string.equals("CERT_EXP_CR")) {
            this.exportCertificateRequest();
            return;
        }
        if (string.equals("CERT_EXP_TCR")) {
            this.exportTrustedCertificate();
            return;
        }
        if (string.equals("CERT_EXP_TC_ALL")) {
            this.exportAllTrustedCertificates();
            return;
        }
        if (string.equals("CERT_EXP_WALLET")) {
            this.exportWallet();
        }
    }

    protected void handlePopupMenuCommand(int n) {
        switch (n) {
            case 9501: {
                this.closeWallet();
                return;
            }
            case 9502: {
                this.refreshWallet();
                return;
            }
            case 9511: {
                this.deleteWallet();
                return;
            }
            case 9514: {
                this.changePassWallet();
                return;
            }
            case 9521: {
                this.exportUserCertificate();
                return;
            }
            case 9522: {
                this.exportCertificateRequest();
                return;
            }
            case 9523: {
                this.importCertificate();
                return;
            }
            case 9524: {
                this.createCertificateReq();
                return;
            }
            case 9525: {
                this.removeUserCertificate();
                return;
            }
            case 9531: {
                this.importTrustedCertificate();
                return;
            }
            case 9541: {
                this.importTrustedCertificate();
                return;
            }
            case 9542: {
                this.exportTrustedCertificate();
                return;
            }
            case 9543: {
                this.removeTrustedCertificate();
                return;
            }
            case 9551: {
                this.removeEntTCList();
                return;
            }
            case 9561: {
                this.exportTrustedCertificate();
                return;
            }
        }
    }

    protected abstract void exitWalletManager();

    protected abstract void newWallet();

    protected abstract void openWallet();

    protected abstract void closeWallet();

    protected abstract void saveWallet();

    protected abstract void saveAsWallet();

    protected abstract void saveSysWallet();

    protected abstract void deleteWallet();

    public abstract void changePassWallet();

    protected abstract void uploadWallet();

    protected abstract void downloadWallet();

    protected abstract void loginWallet();

    protected abstract void logoutWallet();

    protected abstract void refreshWallet();

    protected abstract void preferencesWallet();

    protected abstract void exportSsoWallet();

    protected abstract void createCertificateReq();

    protected abstract void importCertificate();

    protected abstract boolean importTrustedCertificate();

    protected abstract void removeUserCertificate();

    protected abstract void removeTrustedCertificate();

    protected abstract void removeEntTCList();

    protected abstract void exportTrustedCertificate();

    protected abstract void exportCertificateRequest();

    protected abstract void exportUserCertificate();

    protected abstract void exportAllTrustedCertificates();

    protected abstract void exportWallet();

    protected void showNotImplemented() {
        this.showErrorMessage(owmMsgBundle.getMessage("1010", false));
    }

    protected void showNoteMessage(String string) {
        Alert alert = new Alert((Frame)this.m_frame, string, 2, 1);
        alert.setTitle(owmMsgBundle.getMessage("1586", false));
        alert.runAlert();
    }

    protected boolean showExclmConfirmMessage(String string) {
        Alert alert = new Alert((Frame)this.m_frame, string, 1, 3);
        alert.setTitle(owmMsgBundle.getMessage("1586", false));
        return alert.runAlert() == 1;
    }

    protected void showErrorMessage(String string) {
        Alert alert = new Alert((Frame)this.m_frame, string, 0, 1);
        alert.setTitle(owmMsgBundle.getMessage("1586", false));
        alert.runAlert();
    }

    protected boolean showRetryMessage(String string) {
        Alert alert = new Alert((Frame)this.m_frame, String.valueOf(string) + owmMsgBundle.getMessage("1011", false), 1, 3);
        alert.setTitle(owmMsgBundle.getMessage("1586", false));
        return alert.runAlert() == 1;
    }

    protected boolean showConfirmMessage(String string) {
        Alert alert = new Alert((Frame)this.m_frame, string, 2, 3);
        alert.setTitle(owmMsgBundle.getMessage("1586", false));
        return alert.runAlert() == 1;
    }

    public void showStatus(String string) {
        this.m_webApp.showStatus(string);
    }

    protected void debug(String string) {
        AdminTRACE.out("OWM CommandHandler: " + string);
    }
}

