/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.admin.wltmgr.owmo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.security.admin.util.AdminTRACE;
import oracle.security.admin.wltmgr.owmo.OwmoCertificate;
import oracle.security.admin.wltmgr.owmo.OwmoEntTrustedCertList;
import oracle.security.admin.wltmgr.owmo.OwmoReqCertificate;
import oracle.security.wallet.NZCertChainException;
import oracle.security.wallet.NZCertReq;
import oracle.security.wallet.NZCertificate;
import oracle.security.wallet.NZException;
import oracle.security.wallet.NZNative;
import oracle.security.wallet.NZPersona;
import oracle.security.wallet.NZWallet;
import oracle.sysman.emSDK.adminObj.client.ClientObject;

public class OwmoClient
extends ClientObject {
    private static final int CERTIFICATE = 0;
    private static final int CERTREQUEST = 1;
    private static final int PRIVATEKEY = 2;
    static final int PERSONA_INDEX = 0;
    private int m_certStatus;
    private boolean m_isSaved;
    private NZWallet nzWalletObj;
    private boolean m_walletExists;

    public OwmoClient() {
        AdminTRACE.out("Creating Client Object...");
        new NZNative();
        AdminTRACE.out("Loaded NZNative class");
        this.nzWalletObj = null;
        this.m_certStatus = 0;
        this.m_walletExists = false;
        this.m_isSaved = true;
    }

    public boolean isDomesticVer() {
        return NZWallet.isSSLLibDomestic();
    }

    public boolean isWalletExists() {
        return this.m_walletExists;
    }

    public boolean isSaveable() {
        if (this.nzWalletObj == null) {
            return false;
        }
        return this.getCertStatus() != 0 || this.getTrustedCertCount() > 0;
    }

    public boolean isValidPassword(String string) {
        return this.nzWalletObj.getPassword().equals(string);
    }

    public boolean setPassword(String string) {
        if (this.nzWalletObj != null) {
            this.nzWalletObj.setPassword(string);
            this.m_isSaved = false;
            return true;
        }
        return false;
    }

    public int getCertStatus() {
        if (this.nzWalletObj != null && this.m_walletExists) {
            return this.m_certStatus;
        }
        return 0;
    }

    public void setCertStatus(int n) {
        this.m_certStatus = n;
    }

    public boolean isSaved() {
        return this.m_isSaved;
    }

    private void setSaved(boolean bl) {
        this.m_isSaved = bl;
    }

    public int getPersonaCount() {
        if (this.nzWalletObj != null) {
            return 1;
        }
        return 0;
    }

    public String getDefaultDirectory() {
        try {
            String string = NZWallet.getDefaultWRL();
            if (string.startsWith("file")) {
                return string.substring(5);
            }
            return string;
        }
        catch (NZException nZException) {
            String string = nZException.toString();
            AdminTRACE.out(string);
            return null;
        }
    }

    public String getWalletDirectory() {
        String string = this.nzWalletObj.getWRL();
        String string2 = "getWalletDir : " + string;
        AdminTRACE.out(string2);
        String string3 = string = string == null ? null : string.trim();
        if (string != null && string.startsWith("file")) {
            return string.substring(5);
        }
        return string;
    }

    public OwmoReqCertificate getUserCertReq() {
        NZPersona nZPersona = null;
        nZPersona = this.nzWalletObj.getPersonabyIndex(0);
        NZCertReq nZCertReq = null;
        try {
            nZCertReq = nZPersona.getCertRequest(0);
            return new OwmoReqCertificate(OwmoClient.reverseToken(nZCertReq.getSubName()), nZCertReq.getKeySize(), nZCertReq.getKeyType(), OwmoClient.formatB64String(nZCertReq.toB64Format(), 1));
        }
        catch (NZException nZException) {
            String string = nZException.toString();
            AdminTRACE.out(string);
            return null;
        }
    }

    public OwmoCertificate getUserCert() {
        NZPersona nZPersona = null;
        nZPersona = this.nzWalletObj.getPersonabyIndex(0);
        if (nZPersona.getCertificateCount() <= 0) {
            AdminTRACE.out("Certificate Count <= 0");
            return null;
        }
        NZCertificate nZCertificate = nZPersona.getCertificate(0);
        return new OwmoCertificate(OwmoClient.reverseToken(nZCertificate.getSubName()), OwmoClient.reverseToken(nZCertificate.getIssuerName()), nZCertificate.getVersion(), nZCertificate.getSerialNumber(), nZCertificate.getExpiryDate(), nZCertificate.getKeySize(), nZCertificate.getKeyType(), nZCertificate.getMD5Digest(), nZCertificate.getSHA1Digest());
    }

    public Object getCertificate() {
        NZPersona nZPersona = null;
        nZPersona = this.nzWalletObj.getPersonabyIndex(0);
        switch (this.getCertStatus()) {
            case 1: {
                return this.getUserCertReq();
            }
            case 2: {
                return this.getUserCert();
            }
            case 4: {
                return null;
            }
        }
        return null;
    }

    public String getB64EncPrivateKey() {
        NZPersona nZPersona = null;
        try {
            nZPersona = this.nzWalletObj.getPersonabyIndex(0);
            String string = nZPersona.getB64PrivateKeyData(this.nzWalletObj.getPassword());
            return string;
        }
        catch (Exception exception) {
            AdminTRACE.out("Get Enc. private key failed");
            return null;
        }
    }

    public String getB64UserCert() {
        try {
            NZPersona nZPersona = this.nzWalletObj.getPersonabyIndex(0);
            return OwmoClient.formatB64String(nZPersona.getCertificate(0).toB64Format(), 0);
        }
        catch (Exception exception) {
            String string = exception.toString();
            AdminTRACE.out(string);
            return null;
        }
    }

    public String getB64CertReq() {
        try {
            NZPersona nZPersona = this.nzWalletObj.getPersonabyIndex(0);
            String string = nZPersona.getCertRequest(0).toB64Format();
            return OwmoClient.formatB64String(string, 1);
        }
        catch (Exception exception) {
            String string = exception.toString();
            AdminTRACE.out(string);
            return null;
        }
    }

    public int getTrustedCertCount() {
        NZPersona nZPersona = this.nzWalletObj.getPersonabyIndex(0);
        return nZPersona.getUTPCount() + nZPersona.getPTPCount();
    }

    public String getB64TrustedCert(int n) {
        NZCertificate nZCertificate = null;
        try {
            NZPersona nZPersona = this.nzWalletObj.getPersonabyIndex(0);
            nZCertificate = n < nZPersona.getUTPCount() ? nZPersona.getUTPCertificate(n) : nZPersona.getPTPCertificate(n - nZPersona.getUTPCount());
            if (nZCertificate != null) {
                return OwmoClient.formatB64String(nZCertificate.toB64Format(), 0);
            }
            return null;
        }
        catch (Exception exception) {
            String string = exception.toString();
            AdminTRACE.out(string);
            return null;
        }
    }

    public OwmoCertificate getTrustedCert(int n) {
        NZPersona nZPersona = null;
        NZCertificate nZCertificate = null;
        nZPersona = this.nzWalletObj.getPersonabyIndex(0);
        nZCertificate = n < nZPersona.getUTPCount() ? nZPersona.getUTPCertificate(n) : nZPersona.getPTPCertificate(n - nZPersona.getUTPCount());
        String string = "Raw DN: " + nZCertificate.getSubName();
        AdminTRACE.out(string);
        return new OwmoCertificate(OwmoClient.reverseToken(nZCertificate.getSubName()), OwmoClient.reverseToken(nZCertificate.getIssuerName()), nZCertificate.getVersion(), nZCertificate.getSerialNumber(), nZCertificate.getExpiryDate(), nZCertificate.getKeySize(), nZCertificate.getKeyType(), nZCertificate.getMD5Digest(), nZCertificate.getSHA1Digest());
    }

    public String[] getTrustedCertListInfo() {
        String string = "";
        int n = this.getTrustedCertCount();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            string = this.getTrustedCert(n2).getSubjectName();
            String string2 = OwmoClient.getValueFromKey(string, "CN", ",").trim();
            if (string2 == null || string2.length() < 1 || string2.equals("null")) {
                string2 = OwmoClient.getLeftKeyValue(string);
            }
            stringArray[n2] = string2;
            ++n2;
        }
        return stringArray;
    }

    public Vector getTrustedCertTableInfo() {
        int n = this.getTrustedCertCount();
        String string = "";
        OwmoCertificate owmoCertificate = null;
        Vector<String[]> vector = new Vector<String[]>();
        int n2 = 0;
        while (n2 < n) {
            String[] stringArray = new String[3];
            owmoCertificate = this.getTrustedCert(n2);
            string = owmoCertificate.getSubjectName();
            String string2 = OwmoClient.getValueFromKey(string, "CN", ",").trim();
            if (string2 == null || string2.length() < 1 || string2.equals("null")) {
                string2 = OwmoClient.getLeftKeyValue(string);
            }
            stringArray[0] = string2;
            stringArray[1] = String.valueOf(owmoCertificate.getKeySize());
            stringArray[2] = owmoCertificate.getExpDate();
            vector.addElement(stringArray);
            ++n2;
        }
        return vector;
    }

    public int getEntTrustedCertCount() {
        NZPersona nZPersona = this.nzWalletObj.getPersonabyIndex(0);
        return nZPersona.getETPCount();
    }

    public OwmoCertificate getEntTrustedCert(int n) {
        NZPersona nZPersona = this.nzWalletObj.getPersonabyIndex(0);
        NZCertificate nZCertificate = nZPersona.getETPCertificate(n);
        return new OwmoCertificate(nZCertificate.getSubName(), nZCertificate.getIssuerName(), nZCertificate.getVersion(), nZCertificate.getSerialNumber(), nZCertificate.getExpiryDate(), nZCertificate.getKeySize(), nZCertificate.getKeyType(), nZCertificate.getMD5Digest(), nZCertificate.getSHA1Digest());
    }

    public OwmoEntTrustedCertList getEntTrustedCertListInfo() {
        OwmoEntTrustedCertList owmoEntTrustedCertList = new OwmoEntTrustedCertList("Name", "Issuer", 10437474, "August 12' 1998", "August 19' 1999", "F0:67:E4:A3:1C:8B:67:E4:A3:1C:8B:67:E4:A3:1C:8B");
        int n = 0;
        while (n < this.getEntTrustedCertCount()) {
            owmoEntTrustedCertList.addEntTrustedCertInfo("ETC_" + n, "12th Aug 99");
            ++n;
        }
        return owmoEntTrustedCertList;
    }

    public boolean createNewEmptyWallet(String string) {
        this.nzWalletObj = null;
        try {
            this.nzWalletObj = new NZWallet(string);
            this.installB64Cert("NZDST_CLEAR_PTP", "-----BEGIN CERTIFICATE-----\nMIICPDCCAaUCEDJQM89Q0VbzXIGtZVxPyCUwDQYJKoZIhvcNAQECBQAwXzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAxIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTk2MDEyOTAwMDAwMFoXDTIwMDEwNzIzNTk1OVowXzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAxIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDlGb9to1ZhLZlIcfZn3rmN67eehoAKkQ76OCWvRoiC5XOooJskXQ0fzGVuDLDQVoQYh5oGmxChc9+0WDlrbsH2FdWoqD+qEgaNMax/sDTXjzRniAnNFBHiTkVWaR94AoDa3EeRKbs2yWNcxeDXLYd7obcysHswuiovMaruo2fa2wIDAQABMA0GCSqGSIb3DQEBAgUAA4GBAEtEZmBoZOSYG/OwcuaViXzde7OVwB0u2NgZ0C00PcZQmhCGjKo/O6gE/DdSlcPZydvN8oYGxLEb8IKIMEKOF1AcZHq4PplJdJf8rAJD+5YMVgQlDHx8h50kp9jwMim1pN9dokzFFjKoQvZFprY2ueC/ZTaTwtLXa9zeWdaiNfhF\n-----END CERTIFICATE-----\n");
            this.installB64Cert("NZDST_CLEAR_PTP", "-----BEGIN CERTIFICATE-----\nMIICPTCCAaYCEQC6WslMBTuS1qe2307QU5INMA0GCSqGSIb3DQEBAgUAMF8xCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjE3MDUGA1UECxMuQ2xhc3MgMiBQdWJsaWMgUHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw05NjAxMjkwMDAwMDBaFw0wNDAxMDcyMzU5NTlaMF8xCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjE3MDUGA1UECxMuQ2xhc3MgMiBQdWJsaWMgUHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAtlqLow1qI4OAa885h/QhEzMGTCWi7VUSl8WngLn6g8EgoPovFQ18oWBrfnks+gYPOq72G2+x0v8vKFJfg31LxHq3+GYfgFT8t8KOWUoUV0bRmpO+QZEDuxWAk1zr58wIbD8+s0r8/0tsI9VQgiZEGY4jw3HqGSRHBJ51v8imAB8CAwEAATANBgkqhkiG9w0BAQIFAAOBgQC2AB+TV6QHp0DOZUA/VV7t7/pUSaUw1iF8YYfug5MLv7Qz8pisnwa/TqjOFIFMywROWMPPX+5815pvy0GKt3+BuP+EYcYnQ2UdDOyxAArdG6S7x3ggKLKi3TaVLuFUT79guXdoEZkj6OpS6KoATmdOu5C1RZtG644W78QzWzM91Q==\n-----END CERTIFICATE-----\n");
            this.installB64Cert("NZDST_CLEAR_PTP", "-----BEGIN CERTIFICATE-----\nMIICPTCCAaYCEQDknv3zOugOz6URPhmkJAIyMA0GCSqGSIb3DQEBAgUAMF8xCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjE3MDUGA1UECxMuQ2xhc3MgMyBQdWJsaWMgUHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw05NjAxMjkwMDAwMDBaFw0wNDAxMDcyMzU5NTlaMF8xCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjE3MDUGA1UECxMuQ2xhc3MgMyBQdWJsaWMgUHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAyVxZnvIbigEUtBDfBEDb41evakVAj4QMC9Ez2dkRz+4CWB8l9yqoRAWq7AMfeH+ek7maAKojfdashaJjRcdyJ8z0TMZ1cdI5709C8HXfCpDGjiBvmA/4rCNfcCk2pMmG57GaIMtTpYXnPb59mv4kRTPcdhXtD6JxZExlLoFoRacCAwEAATANBgkqhkiG9w0BAQIFAAOBgQBhcOwvP579K+ZoVCGwZ3kIDCCWMYoNer62Jt95LCJpSTbjl3diYaIy13pUITa6Ask05yXaRDWw0lyAXbOU+Pms7qRgdSoflUkjsUp89LNHciFbfperVKxi513srpvSybIk+4Kt6WcVS7qqpvCXoPawl1cAyAw8CaCCBLpB2veZpA==\n-----END CERTIFICATE-----\n");
            this.installB64Cert("NZDST_CLEAR_PTP", NZWallet.rsaSecureStvAuth);
            this.installB64Cert("NZDST_CLEAR_PTP", "-----BEGIN CERTIFICATE-----\nMIIB+jCCAWMCAgGjMA0GCSqGSIb3DQEBBAUAMEUxCzAJBgNVBAYTAlVTMRgwFgYDVQQKEw9HVEUgQ29ycG9yYXRpb24xHDAaBgNVBAMTE0dURSBDeWJlclRydXN0IFJvb3QwHhcNOTYwMjIzMjMwMTAwWhcNMDYwMjIzMjM1OTAwWjBFMQswCQYDVQQGEwJVUzEYMBYGA1UEChMPR1RFIENvcnBvcmF0aW9uMRwwGgYDVQQDExNHVEUgQ3liZXJUcnVzdCBSb290MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQC45k+625h8cXyvRLfTD0bZZOWTwUKOx7pJjTUteueLveUFMVnGsS8KDPufpz+iCWaEVh43KRuH6X4MypqfpX/1FZSj1aJGgthoTNE3FQZor734sLPwKfWVWgkWYXcKIiXUT0Wqx73llt/51KiOQswkwB6RJ0q1bQaAYznEol44AwIDAQABMA0GCSqGSIb3DQEBBAUAA4GBABKzdcZfHeFhVYAA1IFLezEPI2PnPfMD+fQ2qLvZ46WXTeorKeDWanOB5sCJo9Px4KWlIjeaY8JIILTbcuPI9tl8vrGvU9oUtCG41tWW4/5ODFlitppK+ULdjG+BqXH/9ApybW1EDp3zdHSo1TRJ6V6e6bR64eVaH4QwnNOfpSXY\n-----END CERTIFICATE-----\n");
            this.installB64Cert("NZDST_CLEAR_PTP", "-----BEGIN CERTIFICATE-----\nMIICWjCCAcMCAgGlMA0GCSqGSIb3DQEBBAUAMHUxCzAJBgNVBAYTAlVTMRgwFgYDVQQKEw9HVEUgQ29ycG9yYXRpb24xJzAlBgNVBAsTHkdURSBDeWJlclRydXN0IFNvbHV0aW9ucywgSW5jLjEjMCEGA1UEAxMaR1RFIEN5YmVyVHJ1c3QgR2xvYmFsIFJvb3QwHhcNOTgwODEzMDAyOTAwWhcNMTgwODEzMjM1OTAwWjB1MQswCQYDVQQGEwJVUzEYMBYGA1UEChMPR1RFIENvcnBvcmF0aW9uMScwJQYDVQQLEx5HVEUgQ3liZXJUcnVzdCBTb2x1dGlvbnMsIEluYy4xIzAhBgNVBAMTGkdURSBDeWJlclRydXN0IEdsb2JhbCBSb290MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCVD6C28FCc6HrHiM3dFw4usJTQGz0O9pTAipTHBsiQl8i4ZBp6fmw8U+E3KHNgf7KXUwefU/ltWJTSr41tiGeA5u2ylc9yMcqlHHK6XALnZELn+aks1joNrI1CqiQBOeacPwGFVw1Yh0X404Wqk2kmhXBIgD8SFcd5tB8FLztimQIDAQABMA0GCSqGSIb3DQEBBAUAA4GBAG3rGwnpXtlR22ciYaQqPEh346B8pt5zohQDhT37qw4wxYMWM4ETCJ57NE7fQMh017l93PR2VX2bY1QY6fDq81yx2YtCHrnAlU66+tXifPVoYb+O7AWXX1uw16OFNMQkpw0PlZPvy5TYnh+dXIVtx6quTx8itc2VrbqnzPmrC3p/\n-----END CERTIFICATE-----\n");
            this.installB64Cert("NZDST_CLEAR_PTP", "-----BEGIN CERTIFICATE-----\nMIIE2DCCBEGgAwIBAgIEN0rSQzANBgkqhkiG9w0BAQUFADCBwzELMAkGA1UEBhMCVVMxFDASBgNVBAoTC0VudHJ1c3QubmV0MTswOQYDVQQLEzJ3d3cuZW50cnVzdC5uZXQvQ1BTIGluY29ycC4gYnkgcmVmLiAobGltaXRzIGxpYWIuKTElMCMGA1UECxMcKGMpIDE5OTkgRW50cnVzdC5uZXQgTGltaXRlZDE6MDgGA1UEAxMxRW50cnVzdC5uZXQgU2VjdXJlIFNlcnZlciBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw05OTA1MjUxNjA5NDBaFw0xOTA1MjUxNjM5NDBaMIHDMQswCQYDVQQGEwJVUzEUMBIGA1UEChMLRW50cnVzdC5uZXQxOzA5BgNVBAsTMnd3dy5lbnRydXN0Lm5ldC9DUFMgaW5jb3JwLiBieSByZWYuIChsaW1pdHMgbGlhYi4pMSUwIwYDVQQLExwoYykgMTk5OSBFbnRydXN0Lm5ldCBMaW1pdGVkMTowOAYDVQQDEzFFbnRydXN0Lm5ldCBTZWN1cmUgU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGdMA0GCSqGSIb3DQEBAQUAA4GLADCBhwKBgQDNKIM0VBuJ8w+vN5Ex/68xYMmo6LIQaO2f55M28Qpku0f1BBc/I0dNxScZgSYMVHINiC3ZH5oSn7yzcdOAGT9HZnuMNSjSuQrfJNqc1lB5gXpa0zf3wkrYKZImZNHkmGw6AIr1NJtl+O3jEP/9uElY3KDegjlrgbEWGWG5VLbmQwIBA6OCAdcwggHTMBEGCWCGSAGG+EIBAQQEAwIABzCCARkGA1UdHwSCARAwggEMMIHeoIHboIHYpIHVMIHSMQswCQYDVQQGEwJVUzEUMBIGA1UEChMLRW50cnVzdC5uZXQxOzA5BgNVBAsTMnd3dy5lbnRydXN0Lm5ldC9DUFMgaW5jb3JwLiBieSByZWYuIChsaW1pdHMgbGlhYi4pMSUwIwYDVQQLExwoYykgMTk5OSBFbnRydXN0Lm5ldCBMaW1pdGVkMTowOAYDVQQDEzFFbnRydXN0Lm5ldCBTZWN1cmUgU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MQ0wCwYDVQQDEwRDUkwxMCmgJ6AlhiNodHRwOi8vd3d3LmVudHJ1c3QubmV0L0NSTC9uZXQxLmNybDArBgNVHRAEJDAigA8xOTk5MDUyNTE2MDk0MFqBDzIwMTkwNTI1MTYwOTQwWjALBgNVHQ8EBAMCAQYwHwYDVR0jBBgwFoAU8BdiE1U9s/8KAGv7UISX8+1i0BowHQYDVR0OBBYEFPAXYhNVPbP/CgBr+1CEl/PtYtAaMAwGA1UdEwQFMAMBAf8wGQYJKoZIhvZ9B0EABAwwChsEVjQuMAMCBJAwDQYJKoZIhvcNAQEFBQADgYEAkNwwAvpkdMKnCqV8IY00F6j7Rw7/JXyNEwr75Ji174z4xRAN95K+8cPV1ZVqBLssziY2ZcgxxufuP+NXdYR6Ee9GTxj005i7qIcyunL2POI9n9cd2cNgQ4xYDiKWL2KjLB+6rQXvqzJ4h6BUcxm1XAX5Uj5tLUUL9wqT6u0G+bI=-----END CERTIFICATE-----\n");
            this.installB64Cert("NZDST_CLEAR_PTP", "-----BEGIN CERTIFICATE-----\nMIIEXDCCA0SgAwIBAgIEOGO5ZjANBgkqhkiG9w0BAQUFADCBtDEUMBIGA1UEChMLRW50cnVzdC5uZXQxQDA+BgNVBAsUN3d3dy5lbnRydXN0Lm5ldC9DUFNfMjA0OCBpbmNvcnAuIGJ5IHJlZi4gKGxpbWl0cyBsaWFiLikxJTAjBgNVBAsTHChjKSAxOTk5IEVudHJ1c3QubmV0IExpbWl0ZWQxMzAxBgNVBAMTKkVudHJ1c3QubmV0IENlcnRpZmljYXRpb24gQXV0aG9yaXR5ICgyMDQ4KTAeFw05OTEyMjQxNzUwNTFaFw0xOTEyMjQxODIwNTFaMIG0MRQwEgYDVQQKEwtFbnRydXN0Lm5ldDFAMD4GA1UECxQ3d3d3LmVudHJ1c3QubmV0L0NQU18yMDQ4IGluY29ycC4gYnkgcmVmLiAobGltaXRzIGxpYWIuKTElMCMGA1UECxMcKGMpIDE5OTkgRW50cnVzdC5uZXQgTGltaXRlZDEzMDEGA1UEAxMqRW50cnVzdC5uZXQgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkgKDIwNDgpMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArU1LqRKGsuqjIAcVFmQqK0vRvwtKTY7tgHalZ7d4QMBzQshowNtTK91euHaYNZOLGp18EzoOH1u3Hs/lJBQesYGpjX24zGtLA/ECDNyrpUAkAH90lKGdCCmziAv1h3edVc3kw37XamSrhRSGlVuXMlBvPci6Zgzj/L24ScF2iUkZ/cCovYmjZy/Gn7xxGWC4LeksyZB2ZnuU4q941mVTXTzWnLLPKQP5L6RQstRIzgUyVYr9smRMDuSYB3Xbf9+5CFVghTAp+XtIpGmG4zU/HoZdenoVve8AjhUiVBcAkCaTvA5JaJG/+EfTnZVCwQ5N328mz8MYIWJmQ3DW1cAH4QIDAQABo3QwcjARBglghkgBhvhCAQEEBAMCAAcwHwYDVR0jBBgwFoAUVeSB0RGAvtiJuQijMfmhJAkWuXAwHQYDVR0OBBYEFFXkgdERgL7YibkIozH5oSQJFrlwMB0GCSqGSIb2fQdBAAQQMA4bCFY1LjA6NC4wAwIEkDANBgkqhkiG9w0BAQUFAAOCAQEAWUesIYSKF8mciVMeuoCFGsY8Tj6xnLZ8xpJdGGQC49MGCBFhfGPjK50xA3B20qMooPS7mmNz7W3lKtvtFKkrxjYR0CvrB4ul2p5cGZ1WEvVUKcgF7bISKo30Axv/55IQh7A6tcOdBTcSo8f0FbnVpDkWm1M6I5HxqIKiaohowXkCIryqptau37AUX7iH0N18f3v/rxzP5tsHrV7bhZ3QKw0z2wTR5klAEyt2+z7pnIkPFc4YsIV4IU9rTw76NmfNB/L/CNDi3tm/Kq+4h4YhPATKt5Rof8886ZjXOP/swNlQ8C5LWK5Gb9Auw2DaclVyvUxFnmG6v4SBkgPR0ml8xQ==-----END CERTIFICATE-----\n");
            this.installB64Cert("NZDST_CLEAR_PTP", "-----BEGIN CERTIFICATE-----\nMIIElTCCA/6gAwIBAgIEOJsRPDANBgkqhkiG9w0BAQQFADCBujEUMBIGA1UEChMLRW50cnVzdC5uZXQxPzA9BgNVBAsUNnd3dy5lbnRydXN0Lm5ldC9TU0xfQ1BTIGluY29ycC4gYnkgcmVmLiAobGltaXRzIGxpYWIuKTElMCMGA1UECxMcKGMpIDIwMDAgRW50cnVzdC5uZXQgTGltaXRlZDE6MDgGA1UEAxMxRW50cnVzdC5uZXQgU2VjdXJlIFNlcnZlciBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw0wMDAyMDQxNzIwMDBaFw0yMDAyMDQxNzUwMDBaMIG6MRQwEgYDVQQKEwtFbnRydXN0Lm5ldDE/MD0GA1UECxQ2d3d3LmVudHJ1c3QubmV0L1NTTF9DUFMgaW5jb3JwLiBieSByZWYuIChsaW1pdHMgbGlhYi4pMSUwIwYDVQQLExwoYykgMjAwMCBFbnRydXN0Lm5ldCBMaW1pdGVkMTowOAYDVQQDEzFFbnRydXN0Lm5ldCBTZWN1cmUgU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDHwV9OcfHO8GCGD9JYf9Mzly0XonUwtZZkJi9ow0SrqHXmAGc0V55lxyKbc+bT3QgON1WqJUaBbL3+qPZ1V1eMkGxKwz6LS0MKyRFWmponIpnPVZ5h2QLifLZ8OAfc439PmrkDQYC2dWcTC5/oVzbIXQA23mYU2m52H083jIITiQIDAQABo4IBpDCCAaAwEQYJYIZIAYb4QgEBBAQDAgAHMIHjBgNVHR8EgdswgdgwgdWggdKggc+kgcwwgckxFDASBgNVBAoTC0VudHJ1c3QubmV0MT8wPQYDVQQLFDZ3d3cuZW50cnVzdC5uZXQvU1NMX0NQUyBpbmNvcnAuIGJ5IHJlZi4gKGxpbWl0cyBsaWFiLikxJTAjBgNVBAsTHChjKSAyMDAwIEVudHJ1c3QubmV0IExpbWl0ZWQxOjA4BgNVBAMTMUVudHJ1c3QubmV0IFNlY3VyZSBTZXJ2ZXIgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkxDTALBgNVBAMTBENSTDEwKwYDVR0QBCQwIoAPMjAwMDAyMDQxNzIwMDBagQ8yMDIwMDIwNDE3NTAwMFowCwYDVR0PBAQDAgEGMB8GA1UdIwQYMBaAFMtswGvjuz7L/CKc/vuLkpyw8m4iMB0GA1UdDgQWBBTLbMBr47s+y/winP77i5KcsPJuIjAMBgNVHRMEBTADAQH/MB0GCSqGSIb2fQdBAAQQMA4bCFY1LjA6NC4wAwIEkDANBgkqhkiG9w0BAQQFAAOBgQBi24GRzsiad0Iv7L0no1MPUBvqTpLwqa+poLpIYcvvyQbvH9X07t9WLebKahlzqlO+krNQAraFJnJj2HVQYnUUt7NQGj/KEQALhUVpbbalrlHhStyCP2yMNLJ3a9kC9n8O6mUE8c1UyrrJzOCE98g+EZfTYAkYvAX/bIkz8OwVDw==-----END CERTIFICATE-----\n");
            this.m_walletExists = true;
            this.setCertStatus(0);
            this.m_isSaved = true;
            return true;
        }
        catch (NZException nZException) {
            String string2 = nZException.toString();
            AdminTRACE.out(string2);
            return false;
        }
    }

    public boolean createCertificateRequest(String string, int n) {
        String string2 = OwmoClient.setTokenKeyUpperCase(string);
        try {
            NZPersona nZPersona = this.nzWalletObj.getPersonabyIndex(0);
            nZPersona.addCertRequest(string2, n, this.nzWalletObj.getPassword());
            this.setCertStatus(1);
            this.m_isSaved = false;
            return true;
        }
        catch (NZException nZException) {
            String string3 = nZException.toString();
            AdminTRACE.out(string3);
            return false;
        }
    }

    public boolean exportCertRequest(String string) {
        try {
            NZPersona nZPersona = this.nzWalletObj.getPersonabyIndex(0);
            return nZPersona.exportCertReq("file:" + string);
        }
        catch (NZException nZException) {
            String string2 = nZException.toString();
            AdminTRACE.out(string2);
            return false;
        }
    }

    public int installB64Cert(String string, String string2) {
        try {
            NZPersona nZPersona = this.nzWalletObj.getPersonabyIndex(0);
            this.nzWalletObj.installB64Cert(nZPersona, string, string2);
            this.m_isSaved = false;
            return 0;
        }
        catch (NZCertChainException nZCertChainException) {
            String string3 = nZCertChainException.toString();
            AdminTRACE.out(string3);
            return -1;
        }
        catch (NZException nZException) {
            String string4 = nZException.toString();
            AdminTRACE.out(string4);
            return -2;
        }
    }

    public boolean storeSysWallet() {
        String string = null;
        String string2 = null;
        try {
            string = this.nzWalletObj.getWRL();
            string2 = NZWallet.getDefaultWRL();
            if (!string2.startsWith("file:")) {
                string2 = "file:" + string2;
            }
            String string3 = "Default WRL in storeSysWallet:" + string2;
            AdminTRACE.out(string3);
            this.nzWalletObj.setWRL(string2);
            boolean bl = this.nzWalletObj.storeWallet();
            if (bl) {
                this.m_isSaved = true;
            }
            this.nzWalletObj.setWRL(string);
            return bl;
        }
        catch (NZException nZException) {
            this.nzWalletObj.setWRL(string);
            String string4 = nZException.toString();
            AdminTRACE.out(string4);
            return false;
        }
    }

    public boolean storeWallet(String string) {
        try {
            String string2 = "file:" + string;
            this.nzWalletObj.setWRL(string2);
            boolean bl = this.nzWalletObj.storeWallet();
            if (bl) {
                this.m_isSaved = true;
            }
            return bl;
        }
        catch (NZException nZException) {
            String string3 = nZException.toString();
            AdminTRACE.out(string3);
            return false;
        }
    }

    public boolean storeAsWallet(String string) {
        try {
            String string2 = "file:" + string;
            this.nzWalletObj.getWRL();
            this.nzWalletObj.setWRL(string2);
            boolean bl = this.nzWalletObj.storeWallet();
            if (bl) {
                this.m_isSaved = true;
            }
            return bl;
        }
        catch (NZException nZException) {
            String string3 = nZException.toString();
            AdminTRACE.out(string3);
            return false;
        }
    }

    public boolean storeSSOWallet(String string) {
        try {
            String string2 = "file:" + string;
            String string3 = this.nzWalletObj.getWRL();
            this.nzWalletObj.setWRL(string2);
            boolean bl = this.nzWalletObj.storeSSOWallet();
            this.nzWalletObj.setWRL(string3);
            return bl;
        }
        catch (NZException nZException) {
            String string4 = nZException.toString();
            AdminTRACE.out(string4);
            return false;
        }
    }

    public void closeWallet() {
        this.setCertStatus(0);
        if (this.nzWalletObj != null) {
            this.nzWalletObj.freeWalletCMem();
        }
        this.nzWalletObj = null;
        this.m_walletExists = false;
        this.m_isSaved = true;
    }

    public boolean loadWallet(String string, String string2) {
        AdminTRACE.out("Inside loadwallet");
        String string3 = "file:" + string;
        try {
            if (this.nzWalletObj != null) {
                this.nzWalletObj.freeWalletCMem();
                this.nzWalletObj = null;
            }
            this.nzWalletObj = NZWallet.loadWallet(string3, string2);
            if (this.nzWalletObj == null) {
                return false;
            }
            this.nzWalletObj.setWRL(string3);
            this.nzWalletObj.setPassword(string2);
            NZPersona nZPersona = this.nzWalletObj.getPersonabyIndex(0);
            int n = Integer.parseInt(nZPersona.getState());
            String string4 = "Persona State : " + n;
            AdminTRACE.out(string4);
            this.m_walletExists = true;
            this.setCertStatus(n);
            this.m_isSaved = true;
            return true;
        }
        catch (NZException nZException) {
            String string5 = "Loading exception: " + nZException.toString();
            AdminTRACE.out(string5);
            return false;
        }
    }

    public boolean deleteWallet() {
        try {
            String string = this.getWalletDirectory();
            File file = new File(string, "ewallet.der");
            return file.delete();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean deleteTrustPoint(int n) {
        try {
            NZPersona nZPersona = this.nzWalletObj.getPersonabyIndex(0);
            NZCertificate nZCertificate = nZPersona.getPTPCertificate(n);
            boolean bl = this.nzWalletObj.deleteCertOrTP(nZPersona, nZCertificate);
            if (bl) {
                this.m_isSaved = false;
            }
            return bl;
        }
        catch (NZException nZException) {
            String string = nZException.toString();
            AdminTRACE.out(string);
            return false;
        }
    }

    public boolean deleteUserCert() {
        try {
            NZPersona nZPersona = this.nzWalletObj.getPersonabyIndex(0);
            NZCertificate nZCertificate = nZPersona.getCertificate(0);
            boolean bl = this.nzWalletObj.deleteCertOrTP(nZPersona, nZCertificate);
            if (bl) {
                this.m_isSaved = false;
            }
            return bl;
        }
        catch (NZException nZException) {
            String string = nZException.toString();
            AdminTRACE.out(string);
            return false;
        }
    }

    public String getB64CertFromFile(String string, String string2) {
        try {
            File file = new File(string, string2);
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[(int)file.length()];
            fileInputStream.read(byArray);
            fileInputStream.close();
            return new String(byArray);
        }
        catch (Exception exception) {
            return "null";
        }
    }

    public int writeB64Identity(String string, String string2, String string3) {
        try {
            File file = new File(string2, string3);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(string.getBytes());
            fileOutputStream.flush();
            fileOutputStream.close();
            return 0;
        }
        catch (NullPointerException nullPointerException) {
            if (string3 == null) {
                return -2;
            }
            return 0;
        }
        catch (Exception exception) {
            String string4 = "Exception Caught: " + exception.toString();
            AdminTRACE.out(string4);
            return -1;
        }
    }

    public static String getValueFromKey(String string, String string2, String string3) {
        String string4 = new String();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, string3);
            while (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
                if (!string4.startsWith(string2)) continue;
                return string4.substring(string2.length() + 1).trim();
            }
        }
        return new String("null");
    }

    public static String formatB64String(String string, int n) {
        int n2 = 0;
        int n3 = 0;
        switch (n) {
            case 0: {
                n2 = 28;
                n3 = 26;
                break;
            }
            case 1: {
                n2 = 40;
                n3 = 38;
                break;
            }
            case 2: {
                n2 = 38;
                n3 = 36;
                break;
            }
            default: {
                return string;
            }
        }
        int n4 = string.length();
        String string2 = string.substring(n2, n4 - n3);
        int n5 = string2.length();
        int n6 = n5 / 76;
        String string3 = new String();
        String string4 = new String();
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (true) {
            if ((n8 = (n7 = n9 * 76) + 76) > n5) break;
            string4 = String.valueOf(string2.substring(n7, n8)) + "\n";
            string3 = String.valueOf(string3) + string4;
            ++n9;
        }
        n8 = n5;
        string4 = string2.substring(n7, n8);
        string3 = String.valueOf(string3) + string4;
        string3 = String.valueOf(string.substring(0, n2)) + string3.trim() + "\n" + string.substring(n4 - n3, n4);
        return string3;
    }

    public static String getLeftKeyValue(String string) {
        if (string != null) {
            try {
                int n = string.indexOf("=");
                int n2 = string.indexOf("=", n + 1);
                String string2 = string.substring(n + 1, n2);
                int n3 = string2.lastIndexOf(",");
                string2 = string2.substring(0, n3);
                if (string2.startsWith("\"")) {
                    string2 = string2.substring(1, string2.length() - 1);
                }
                return string2;
            }
            catch (Exception exception) {
                return string;
            }
        }
        return string;
    }

    public static String reverseString(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        char[] cArray2 = string.toCharArray();
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = cArray2[n - n2 - 1];
            ++n2;
        }
        return new String(cArray);
    }

    public static String reverseToken(String string) {
        String string2 = new String();
        String string3 = new String();
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        int n = 0;
        int n2 = 0;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
            int n3 = stringTokenizer.countTokens();
            n2 = 0;
            while (n2 < n3) {
                string3 = stringTokenizer.nextToken();
                n = string3.lastIndexOf(",");
                if (n2 == 0) {
                    vector2.addElement(string3);
                } else if (n2 == n3 - 1) {
                    vector.addElement(string3);
                } else {
                    vector.addElement(string3.substring(0, n).trim());
                    vector2.addElement(string3.substring(n + 1).trim());
                }
                ++n2;
            }
            n2 = vector.size() - 1;
            while (n2 >= 0) {
                string2 = String.valueOf(string2) + (String)vector2.elementAt(n2) + "=" + (String)vector.elementAt(n2);
                if (n2 > 0) {
                    string2 = String.valueOf(string2) + ", ";
                }
                --n2;
            }
            return string2;
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static String setTokenKeyUpperCase(String string) {
        try {
            String string2 = string.trim();
            String string3 = new String();
            Vector<Integer> vector = new Vector<Integer>();
            Vector<Integer> vector2 = new Vector<Integer>();
            int n = 0;
            int n2 = 0;
            if (string2 != null && string2.length() > 0) {
                while ((n = string2.indexOf("=", n + 1)) >= 0) {
                    n2 = string2.lastIndexOf(",", n);
                    if (n2 < 0) {
                        n2 = 0;
                    }
                    vector.addElement(new Integer(n2));
                    vector2.addElement(new Integer(n));
                }
                vector.addElement(new Integer(string2.length()));
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                while (string3.length() != string2.length()) {
                    n4 = (Integer)vector.elementAt(n3);
                    n5 = (Integer)vector2.elementAt(n3);
                    n6 = (Integer)vector.elementAt(++n3);
                    String string4 = string2.substring(n4, n5).toUpperCase();
                    string3 = String.valueOf(string3) + string4 + string2.substring(n5, n6);
                }
                return string3;
            }
        }
        catch (Exception exception) {
            AdminTRACE.out(exception.toString());
            return string;
        }
        return string;
    }

    private static void debug(String string) {
        AdminTRACE.out(string);
    }

    private static void debug(Exception exception) {
        AdminTRACE.out(exception.toString());
    }
}

